/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.users.core;

import java.util.Objects;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.passage.lic.users.UserDescriptor;
import org.eclipse.passage.lic.users.UserLicenseDescriptor;
import org.eclipse.passage.lic.users.UserOriginDescriptor;
import org.eclipse.passage.lic.users.model.api.User;
import org.eclipse.passage.lic.users.model.api.UserLicense;
import org.eclipse.passage.lic.users.model.api.UserOrigin;
import org.eclipse.passage.loc.internal.emf.DomainContentAdapter;
import org.eclipse.passage.loc.internal.emf.EditingDomainRegistry;
import org.eclipse.passage.loc.internal.users.core.UserDomainRegistry;

public class UsersDomainRegistryTracker
extends DomainContentAdapter<UserOriginDescriptor, UserDomainRegistry> {
    public UsersDomainRegistryTracker(UserDomainRegistry registry) {
        super((EditingDomainRegistry)registry);
    }

    public void notifyChanged(Notification notification) {
        Object notifier = notification.getNotifier();
        if (notifier instanceof UserOrigin) {
            UserOrigin userOrigin = (UserOrigin)notifier;
            switch (notification.getFeatureID(UserOrigin.class)) {
                case 0: {
                    this.processUserOriginIdentifier(userOrigin, notification);
                    break;
                }
                case 3: {
                    this.processUserOriginUsers(userOrigin, notification);
                    break;
                }
            }
        } else if (notifier instanceof User) {
            User user = (User)notifier;
            switch (notification.getFeatureID(User.class)) {
                case 1: {
                    this.processUserEmail(user, notification);
                    break;
                }
                case 7: {
                    this.processUserUserLicenses(user, notification);
                    break;
                }
            }
        } else if (notifier instanceof UserLicense) {
            UserLicense userLicense = (UserLicense)notifier;
            switch (notification.getFeatureID(User.class)) {
                case 7: {
                    this.processUserLicensePackageIdentifier(userLicense, notification);
                    break;
                }
            }
        }
        super.notifyChanged(notification);
    }

    protected void processUserOriginIdentifier(UserOrigin userOrigin, Notification notification) {
        String oldValue = notification.getOldStringValue();
        String newValue = notification.getNewStringValue();
        switch (notification.getEventType()) {
            case 1: {
                if (oldValue != null) {
                    ((UserDomainRegistry)this.registry).unregisterUserOrigin(oldValue);
                }
                if (newValue == null) break;
                ((UserDomainRegistry)this.registry).registerUserOrigin((UserOriginDescriptor)userOrigin);
                break;
            }
        }
    }

    protected void processUserOriginUsers(UserOrigin userOrigin, Notification notification) {
        Object oldValue = notification.getOldValue();
        Object newValue = notification.getNewValue();
        switch (notification.getEventType()) {
            case 3: {
                if (!(newValue instanceof User)) break;
                User user = (User)newValue;
                Objects.equals(userOrigin, user.getUserOrigin());
                String email = user.getEmail();
                if (email == null) break;
                ((UserDomainRegistry)this.registry).registerUser((UserDescriptor)user);
                break;
            }
            case 4: {
                if (!(oldValue instanceof User)) break;
                User user = (User)oldValue;
                Objects.equals(userOrigin, user.getUserOrigin());
                String email = user.getEmail();
                if (email == null) break;
                ((UserDomainRegistry)this.registry).unregisterUser(email);
                break;
            }
        }
    }

    protected void processUserEmail(User user, Notification notification) {
        String oldValue = notification.getOldStringValue();
        String newValue = notification.getNewStringValue();
        switch (notification.getEventType()) {
            case 1: {
                if (oldValue != null) {
                    ((UserDomainRegistry)this.registry).unregisterUser(oldValue);
                }
                if (newValue == null) break;
                ((UserDomainRegistry)this.registry).registerUser((UserDescriptor)user);
                break;
            }
        }
    }

    protected void processUserUserLicenses(User user, Notification notification) {
        Object oldValue = notification.getOldValue();
        Object newValue = notification.getNewValue();
        switch (notification.getEventType()) {
            case 3: {
                if (!(newValue instanceof UserLicense)) break;
                UserLicense userLicense = (UserLicense)newValue;
                Objects.equals(user, userLicense.getUser());
                String identifier = userLicense.getPackIdentifier();
                if (identifier == null) break;
                ((UserDomainRegistry)this.registry).registerUserLicense((UserLicenseDescriptor)userLicense);
                break;
            }
            case 4: {
                if (!(oldValue instanceof UserLicense)) break;
                UserLicense userLicense = (UserLicense)oldValue;
                Objects.equals(user, userLicense.getUser());
                String packIdentifier = userLicense.getPackIdentifier();
                if (packIdentifier == null) break;
                ((UserDomainRegistry)this.registry).unregisterUserLicense(packIdentifier);
                break;
            }
        }
    }

    protected void processUserLicensePackageIdentifier(UserLicense userLicense, Notification notification) {
        String oldValue = notification.getOldStringValue();
        String newValue = notification.getNewStringValue();
        switch (notification.getEventType()) {
            case 1: {
                if (oldValue != null) {
                    ((UserDomainRegistry)this.registry).unregisterUserLicense(oldValue);
                }
                if (newValue == null) break;
                ((UserDomainRegistry)this.registry).registerUserLicense((UserLicenseDescriptor)userLicense);
                break;
            }
        }
    }
}

