/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.report.internal.core;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.passage.lic.users.UserDescriptor;
import org.eclipse.passage.lic.users.UserLicenseDescriptor;
import org.eclipse.passage.lic.users.registry.UserRegistry;
import org.eclipse.passage.loc.report.internal.core.CustomerStorage;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public final class Customers
implements CustomerStorage {
    private UserRegistry registry;

    @Override
    public Set<UserDescriptor> forProducts(Set<String> products) {
        return StreamSupport.stream(this.registry.getUserLicenses().spliterator(), false).filter(lic -> products.contains(lic.getProductIdentifier())).map(UserLicenseDescriptor::getUser).collect(Collectors.toSet());
    }

    @Override
    public Set<String> allProducts() {
        return StreamSupport.stream(this.registry.getUserLicenses().spliterator(), false).map(UserLicenseDescriptor::getProductIdentifier).collect(Collectors.toSet());
    }

    @Reference
    public void installUserRegistry(UserRegistry userRegistry) {
        this.registry = userRegistry;
    }
}

