/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.windows;

import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.WinNT;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.jna.platform.windows.Ole32;
import oshi.jna.platform.windows.Wbemcli;
import oshi.jna.platform.windows.WbemcliUtil;

public class WmiUtil {
    public static final WmiUtil INSTANCE = new WmiUtil();
    private static final Logger LOG = LoggerFactory.getLogger(WmiUtil.class);
    private static int wmiTimeout = -1;
    private static int connectionCacheTimeout = 300000;
    private static Set<String> hasNamespaceCache = new HashSet<String>();
    private static Set<String> hasNotNamespaceCache = new HashSet<String>();
    private static Map<String, WmiConnection> connectionCache = new HashMap<String, WmiConnection>();
    private static long nextCacheClear = System.currentTimeMillis() + (long)connectionCacheTimeout;
    private static Set<String> failedWmiClassNames = new HashSet<String>();
    public static final String OHM_NAMESPACE = "ROOT\\OpenHardwareMonitor";
    private static boolean comInitialized = false;
    private static boolean securityInitialized = false;

    private WmiUtil() {
        WmiUtil.initCOM();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                WmiUtil.unInitCOM();
            }
        });
    }

    public static boolean hasNamespace(String namespace) {
        if (hasNamespaceCache.contains(namespace)) {
            return true;
        }
        if (hasNotNamespaceCache.contains(namespace)) {
            return false;
        }
        return WbemcliUtil.hasNamespace(namespace);
    }

    public static <T extends Enum<T>> WbemcliUtil.WmiResult<T> queryWMI(WbemcliUtil.WmiQuery<T> query) {
        WbemcliUtil wbemcliUtil = WbemcliUtil.INSTANCE;
        wbemcliUtil.getClass();
        WbemcliUtil.WmiResult<T> result = new WbemcliUtil.WmiResult<T>(wbemcliUtil, query.getPropertyEnum());
        if (failedWmiClassNames.contains(query.getWmiClassName())) {
            return result;
        }
        try {
            if (!WmiUtil.isComInitialized()) {
                WmiUtil.initCOM();
            }
            WmiConnection conn = WmiUtil.connectToNamespace(query.getNameSpace());
            Wbemcli.IEnumWbemClassObject enumerator = WbemcliUtil.selectProperties(conn.getService(), query);
            result = WbemcliUtil.enumerateProperties(enumerator, query.getPropertyEnum(), wmiTimeout);
            enumerator.Release();
        }
        catch (Wbemcli.WbemcliException e) {
            if (!OHM_NAMESPACE.equals(query.getNameSpace())) {
                switch (e.getErrorCode()) {
                    case -2147217394: {
                        LOG.error("WMI Failed connecting to namespace {}", (Object)query.getNameSpace());
                        break;
                    }
                    case -2147217392: {
                        LOG.warn("WMI class {} not found, ignoring further requests.", (Object)query.getWmiClassName());
                        failedWmiClassNames.add(query.getWmiClassName());
                        break;
                    }
                    case -2147217385: {
                        LOG.error("Invalid Query: SELECT {} FROM {}.", query.getPropertyEnum().getEnumConstants(), (Object)query.getWmiClassName());
                        break;
                    }
                    default: {
                        LOG.error(e.getMessage());
                    }
                }
            }
        }
        catch (TimeoutException e) {
            Enum[] props = (Enum[])query.getPropertyEnum().getEnumConstants();
            StringBuilder sb = new StringBuilder("SELECT ");
            sb.append(props[0].name());
            for (int i = 1; i < props.length; ++i) {
                sb.append(',').append(props[i].name());
            }
            sb.append(" FROM ").append(query.getWmiClassName());
            LOG.error("WMI query timed out after {} ms: {}", (Object)wmiTimeout, (Object)sb);
        }
        return result;
    }

    private static WmiConnection connectToNamespace(String namespace) {
        if (System.currentTimeMillis() > nextCacheClear) {
            WmiUtil.closeStaleConnections();
            nextCacheClear = System.currentTimeMillis() + (long)connectionCacheTimeout;
        }
        if (connectionCache.containsKey(namespace)) {
            WmiConnection conn = connectionCache.get(namespace);
            if (conn.isStale()) {
                conn.close();
                connectionCache.remove(namespace);
            } else {
                return conn;
            }
        }
        Wbemcli.IWbemServices svc = WbemcliUtil.connectServer(namespace);
        WmiUtil wmiUtil = INSTANCE;
        wmiUtil.getClass();
        WmiConnection conn = wmiUtil.new WmiConnection(svc);
        connectionCache.put(namespace, conn);
        return conn;
    }

    private static void closeStaleConnections() {
        Iterator<Map.Entry<String, WmiConnection>> iter = connectionCache.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, WmiConnection> entry = iter.next();
            if (!entry.getValue().isStale()) continue;
            entry.getValue().close();
            iter.remove();
        }
    }

    public static void initCOM() {
        WinNT.HRESULT hres = null;
        if (!WmiUtil.isComInitialized()) {
            hres = Ole32.INSTANCE.CoInitializeEx(null, 0);
            switch (hres.intValue()) {
                case 0: {
                    comInitialized = true;
                    break;
                }
                case -2147417850: 
                case 1: {
                    break;
                }
                default: {
                    throw new Wbemcli.WbemcliException("Failed to initialize COM library.", hres.intValue());
                }
            }
        }
        if (!WmiUtil.isSecurityInitialized()) {
            hres = Ole32.INSTANCE.CoInitializeSecurity(null, -1, null, null, 0, 3, null, 0, null);
            if (COMUtils.FAILED((WinNT.HRESULT)hres) && hres.intValue() != -2147417831) {
                Ole32.INSTANCE.CoUninitialize();
                throw new Wbemcli.WbemcliException("Failed to initialize security.", hres.intValue());
            }
            securityInitialized = true;
        }
    }

    public static void unInitCOM() {
        if (WmiUtil.isComInitialized()) {
            Ole32.INSTANCE.CoUninitialize();
            comInitialized = false;
        }
    }

    public static boolean isComInitialized() {
        return comInitialized;
    }

    public static boolean isSecurityInitialized() {
        return securityInitialized;
    }

    public static int getWmiTimeout() {
        return wmiTimeout;
    }

    public static void setWmiTimeout(int wmiTimeout) {
        WmiUtil.wmiTimeout = wmiTimeout;
    }

    public static int getConnectionCacheTimeout() {
        return connectionCacheTimeout;
    }

    public static void setConnectionCacheTimeout(int connectionCacheTimeout) {
        WmiUtil.connectionCacheTimeout = connectionCacheTimeout;
    }

    public class WmiConnection {
        private long staleAfter;
        private Wbemcli.IWbemServices svc;

        WmiConnection(Wbemcli.IWbemServices svc) {
            this.svc = svc;
            this.refresh();
        }

        public Wbemcli.IWbemServices getService() {
            return this.svc;
        }

        public boolean isStale() {
            return System.currentTimeMillis() > this.staleAfter;
        }

        public void refresh() {
            this.staleAfter = System.currentTimeMillis() + (long)connectionCacheTimeout;
        }

        public void close() {
            this.svc.Release();
        }
    }
}

