/*******************************************************************************
 * @license
 * Copyright (c) 2017 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0
 * (https://www.eclipse.org/legal/epl-v10.html), and the Eclipse Distribution
 * License v1.0 (https://www.eclipse.org/org/documents/edl-v10.html).
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
define([
	'i18n!javascript/nls/messages'
], function(Messages) {

	return Object.freeze({
		author: {
			doc: Messages.packageAuthorDoc,
			url: "https://docs.npmjs.com/files/package.json#people-fields-author-contributors"
		},
		bin: {
			doc: Messages.packageBinDoc,
			url: "https://docs.npmjs.com/files/package.json#bin"
		},
		bugs: {
			doc: Messages.packageBugsDoc,
			url: "https://docs.npmjs.com/files/package.json#bugs"
		},
		bundledDependencies: {
			doc: Messages.packageBundledDepsDoc,
			url: "https://docs.npmjs.com/files/package.json#bundleddependencies"
		},
		config: {
			doc: Messages.packageConfigDoc,
			url: "https://docs.npmjs.com/files/package.json#config"
		},
		contributors: {
			doc: Messages.packageContributorsDoc,
			url: "https://docs.npmjs.com/files/package.json#people-fields-author-contributors"	
		},
		cpu: {
			doc: Messages.packageCpuDoc,
			url: "https://docs.npmjs.com/files/package.json#cpu"
		},
		dependencies: {
			doc: Messages.packageDependenciesDoc,
			url: "https://docs.npmjs.com/files/package.json#dependencies"
		},
		description: {
			doc: Messages.packageDescriptionDoc,
			url: "https://docs.npmjs.com/files/package.json#description-1"
		},
		devDependencies: {
			doc: Messages.packageDevDepsDoc,
			url: "https://docs.npmjs.com/files/package.json#devdependencies"
		},
		directories: {
			doc: Messages.packageDirectoriesDoc,
			url: "https://docs.npmjs.com/files/package.json#directories"
		},
		directories_bin: {
			doc: Messages.packageDirBinDoc,
			url: "https://docs.npmjs.com/files/package.json#directoriesbin"
		},
		directories_doc: {
			doc: Messages.packageDirDocDoc,
			url: "https://docs.npmjs.com/files/package.json#directoriesdoc"
		},
		directories_example: {
			doc: Messages.packageDirExamplesDoc,
			url: "https://docs.npmjs.com/files/package.json#directoriesexample"
		},
		directories_lib: {
			doc: Messages.packageDirLibDoc,
			url: "https://docs.npmjs.com/files/package.json#directorieslib"
		},
		directories_man: {
			doc: Messages.packageDirManDoc,
			url: "https://docs.npmjs.com/files/package.json#directoriesman"
		},
		directories_test: {
			doc: Messages.packageDirTestDoc,
			url: "https://docs.npmjs.com/files/package.json#directoriestest"
		},
		engines: {
			doc: Messages.packageEnginesDoc,
			url: "https://docs.npmjs.com/files/package.json#engines"
		},
		engineStrict: {
			doc: Messages.packageEngineStrictDoc,
			url: "https://docs.npmjs.com/files/package.json#enginestrict"
		},
		eslintConfig: {
			doc: Messages.packageEslintConfigDoc,
			url: "https://eslint.org/docs/user-guide/configuring#configuration-file-formats"
		},
		files: {
			doc: Messages.packageFilesDoc,
			url: "https://docs.npmjs.com/files/package.json#files"	
		},
		homepage: {
			doc: Messages.packageHomepageDoc,
			url: 'https://docs.npmjs.com/files/package.json#homepage'
		},
		keywords: {
			doc: Messages.packageKeywordsDoc,
			url: "https://docs.npmjs.com/files/package.json#keywords"
		},
		license: {
			doc: Messages.packageLicenseDoc,
			url: "https://docs.npmjs.com/files/package.json#license"
		},
		main: {
			doc: Messages.packageMainDoc,
			url: "https://docs.npmjs.com/files/package.json#main"
		},
		man: {
			doc: Messages.packageManDoc,
			url: "https://docs.npmjs.com/files/package.json#man"
		},
		name: {
			doc: Messages.packageNameDoc,
			url: "https://docs.npmjs.com/files/package.json#name"
		},
		optionalDependencies: {
			doc: Messages.packageOptionalDepsDoc,
			url: "https://docs.npmjs.com/files/package.json#optionaldependencies"
		},
		os: {
			doc: Messages.packageOsDoc,
			url: "https://docs.npmjs.com/files/package.json#os"
		},
		peerDependencies: {
			doc: Messages.packagePeerDepsDoc,
			url: "https://docs.npmjs.com/files/package.json#peerdependencies"
		},
		preferGlobal: {
			doc: Messages.packagePreferGlobalDoc,
			url: "https://docs.npmjs.com/files/package.json#preferglobal"
		},
		"private": {
			doc: Messages.packagePrivateDoc,
			url: "https://docs.npmjs.com/files/package.json#private"
		},
		publishConfig: {
			doc: Messages.packagePublishConfigDoc,
			url: "https://docs.npmjs.com/files/package.json#publishconfig"
		},
		repository: {
			doc: Messages.packageRepositoryDoc,
			url: "https://docs.npmjs.com/files/package.json#repository"
		},
		scripts: {
			doc: Messages.packageScriptsDoc,
			url: "https://docs.npmjs.com/files/package.json#scripts"
		},
		version: {
			doc: Messages.packageVersionDoc,
			url: "https://docs.npmjs.com/files/package.json#version"
		}
	});
});