/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipartMessageReader {
    protected static final Logger logger = LoggerFactory.getLogger(MultipartMessageReader.class);
    private byte[] messageBody;
    private int bodyIndex = 0;
    private byte[] currentPart = null;
    private final String CRLF = "\r\n";
    private final byte CR = (byte)13;
    private final byte LF = (byte)10;
    private final String boundaryPrefix = "--";
    private byte[] crlfAndPrefixBoundary;

    public MultipartMessageReader(String boundary, byte[] messageBody) {
        this.crlfAndPrefixBoundary = new String("\r\n--" + boundary).getBytes();
        this.messageBody = messageBody;
    }

    private boolean setCurrentPart(int startPos, int size) {
        if (this.messageBody == null || startPos < 0 || size <= 0 || startPos + size >= this.messageBody.length) {
            return false;
        }
        this.currentPart = new byte[size];
        int i = 0;
        while (i < size) {
            this.currentPart[i] = this.messageBody[startPos + i];
            ++i;
        }
        return true;
    }

    private int discardPartHeader(int pos) {
        while (pos < this.messageBody.length) {
            if (this.messageBody[pos] == 13 && this.messageBody[pos + 1] == 10) {
                pos += 2;
                continue;
            }
            return pos;
        }
        return -1;
    }

    private int findNextBoundaryStartPosition(int startPos) {
        int endPos = 0;
        int cmpBufLen = this.crlfAndPrefixBoundary.length;
        while (startPos + endPos < this.messageBody.length) {
            if (this.messageBody[startPos + endPos] == this.crlfAndPrefixBoundary[endPos]) {
                if (endPos + 1 == cmpBufLen) {
                    return startPos;
                }
                ++endPos;
                continue;
            }
            startPos += endPos + 1;
            endPos = 0;
        }
        return -1;
    }

    private int findPartEndPosition(int startPos) {
        return this.findNextBoundaryStartPosition(startPos);
    }

    private int findPartStartPosition(int startPos) {
        int pos = this.findNextBoundaryStartPosition(startPos);
        if (pos != -1 && pos + this.crlfAndPrefixBoundary.length + 2 < this.messageBody.length && this.messageBody[pos] == 13 && this.messageBody[pos + 1] == 10) {
            return this.discardPartHeader(pos + this.crlfAndPrefixBoundary.length + 2);
        }
        return -1;
    }

    public boolean readNextPart() {
        if (this.bodyIndex >= this.messageBody.length) {
            return false;
        }
        int partStartPos = this.findPartStartPosition(this.bodyIndex);
        if (partStartPos == -1) {
            this.bodyIndex = this.messageBody.length;
            return false;
        }
        int partEndPos = this.findPartEndPosition(partStartPos);
        if (partEndPos == -1) {
            this.bodyIndex = this.messageBody.length;
            return false;
        }
        if (this.setCurrentPart(partStartPos, partEndPos - partStartPos)) {
            this.bodyIndex = partEndPos;
            return true;
        }
        this.bodyIndex = this.messageBody.length;
        return false;
    }

    public byte[] getPart() {
        return this.currentPart;
    }
}

