/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.ExpiryCache;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.objects.App;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetAppCommand
extends AbstractCFCommand {
    private static final int CACHE_EXPIRES_MS = 30000;
    private static final int MAX_CACHE_SIZE = 1000;
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName;
    private String name;
    private App app;
    static ExpiryCache<App> appCache = new ExpiryCache(1000, 30000);

    public GetAppCommand(Target target, String name) {
        super(target);
        Object[] bindings = new String[]{name};
        this.commandName = NLS.bind((String)"Get application {0}", (Object[])bindings);
        this.name = name;
    }

    public static void expire(Target target, String name) {
        appCache.remove(Arrays.asList(target, name));
    }

    @Override
    public ServerStatus _doIt() {
        try {
            String appsUrl;
            List<Object> key = Arrays.asList(this.target, this.name);
            this.app = appCache.get(key);
            if (this.app != null) {
                return new ServerStatus(Status.OK_STATUS, 200, this.app.toJSON());
            }
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            URI appsURI = targetURI.resolve(appsUrl = this.target.getSpace().getCFJSON().getJSONObject("entity").getString("apps_url"));
            GetMethod getAppsMethod = new GetMethod(appsURI.toString());
            ServerStatus confStatus = HttpUtil.configureHttpMethod((HttpMethod)getAppsMethod, this.target.getCloud());
            if (!confStatus.isOK()) {
                return confStatus;
            }
            getAppsMethod.setQueryString("q=name:" + URLEncoder.encode(this.name, "UTF8") + "&inline-relations-depth=1");
            ServerStatus getStatus = HttpUtil.executeMethod((HttpMethodBase)getAppsMethod);
            if (!getStatus.isOK()) {
                return getStatus;
            }
            JSONObject apps = getStatus.getJsonData();
            if (!apps.has("resources") || apps.getJSONArray("resources").length() == 0) {
                return new ServerStatus(4, 404, "Application not found", null);
            }
            JSONObject appJSON = apps.getJSONArray("resources").getJSONObject(0).getJSONObject("metadata");
            String summaryAppUrl = String.valueOf(appJSON.getString("url")) + "/summary";
            URI summaryAppURI = targetURI.resolve(summaryAppUrl);
            GetMethod getSummaryMethod = new GetMethod(summaryAppURI.toString());
            confStatus = HttpUtil.configureHttpMethod((HttpMethod)getSummaryMethod, this.target.getCloud());
            if (!confStatus.isOK()) {
                return confStatus;
            }
            getStatus = HttpUtil.executeMethod((HttpMethodBase)getSummaryMethod);
            if (!getStatus.isOK()) {
                return getStatus;
            }
            JSONObject summaryJSON = getStatus.getJsonData();
            String instancesUrl = String.valueOf(appJSON.getString("url")) + "/instances";
            URI instancesURI = targetURI.resolve(instancesUrl);
            GetMethod getInstancesMethod = new GetMethod(instancesURI.toString());
            confStatus = HttpUtil.configureHttpMethod((HttpMethod)getInstancesMethod, this.target.getCloud());
            if (!confStatus.isOK()) {
                return confStatus;
            }
            getStatus = HttpUtil.executeMethod((HttpMethodBase)getInstancesMethod);
            JSONObject instancesJSON = getStatus.getJsonData();
            this.app = new App();
            this.app.setAppJSON(appJSON);
            this.app.setSummaryJSON(summaryJSON);
            this.app.setName(summaryJSON.getString("name"));
            this.app.setGuid(summaryJSON.getString("guid"));
            appCache.put(key, this.app);
            JSONObject result = this.app.toJSON();
            result.put("instances_details", (Object)instancesJSON);
            return new ServerStatus(Status.OK_STATUS, 200, this.app.toJSON());
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }

    public App getApp() {
        return this.app;
    }
}

