/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.objects;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.orion.server.core.resources.Property;
import org.eclipse.orion.server.core.resources.ResourceShape;
import org.eclipse.orion.server.core.resources.annotations.PropertyDescription;
import org.eclipse.orion.server.core.resources.annotations.ResourceDescription;
import org.eclipse.orion.server.git.BaseToCloneConverter;
import org.eclipse.orion.server.git.objects.GitObject;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.osgi.util.NLS;
import org.json.JSONException;
import org.json.JSONObject;

@ResourceDescription(type="Diff")
public class Diff
extends GitObject {
    public static final String RESOURCE = "diff";
    public static final String TYPE = "Diff";
    private static final ResourceShape DEFAULT_RESOURCE_SHAPE = new ResourceShape();
    private URI baseLocation;

    public Diff(URI baseLocation, Repository db) throws URISyntaxException, CoreException {
        super(BaseToCloneConverter.getCloneLocation(baseLocation, BaseToCloneConverter.DIFF), db);
        Property[] defaultProperties = new Property[]{new Property("Location"), new Property("CloneLocation"), new Property("Old"), new Property("New"), new Property("Base")};
        DEFAULT_RESOURCE_SHAPE.setProperties(defaultProperties);
        this.baseLocation = baseLocation;
    }

    @Override
    public JSONObject toJSON() throws JSONException, URISyntaxException, IOException, CoreException {
        return (JSONObject)this.jsonSerializer.serialize((Object)this, DEFAULT_RESOURCE_SHAPE);
    }

    @Override
    protected URI getLocation() throws URISyntaxException {
        return this.baseLocation;
    }

    @PropertyDescription(name="Old")
    private URI getOldLocation() throws URISyntaxException {
        IPath path = new Path(this.baseLocation.getPath()).removeFirstSegments(2);
        return this.getOldLocation(this.baseLocation, path);
    }

    private URI getOldLocation(URI location, IPath path) throws URISyntaxException {
        String scope = path.segment(0);
        if (scope.contains("..")) {
            String[] commits = scope.split("\\.\\.");
            if (commits.length != 2) {
                throw new IllegalArgumentException(NLS.bind((String)"Illegal scope format, expected {old}..{new}, was {0}", (Object)scope));
            }
            IPath p = new Path("/gitapi/commit").append(commits[0]).append(path.removeFirstSegments(1));
            return new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), p.toString(), "parts=body", null);
        }
        if (scope.equals("Cached")) {
            IPath p = new Path("/gitapi/commit").append("HEAD").append(path.removeFirstSegments(1));
            return new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), p.toString(), "parts=body", null);
        }
        if (scope.equals("Default")) {
            IPath p = new Path("/gitapi/index").append(path.removeFirstSegments(1));
            return new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), p.toString(), null, null);
        }
        IPath p = new Path("/gitapi/commit").append(scope).append(path.removeFirstSegments(1));
        return new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), p.toString(), "parts=body", null);
    }

    @PropertyDescription(name="New")
    private URI getNewLocation() throws URISyntaxException {
        IPath path = new Path(this.baseLocation.getPath()).removeFirstSegments(2);
        return this.getNewLocation(this.baseLocation, path);
    }

    private URI getNewLocation(URI location, IPath path) throws URISyntaxException {
        String scope = path.segment(0);
        if (scope.contains("..")) {
            String[] commits = scope.split("\\.\\.");
            if (commits.length != 2) {
                throw new IllegalArgumentException(NLS.bind((String)"Illegal scope format, expected {old}..{new}, was {0}", (Object)scope));
            }
            IPath p = new Path("/gitapi/commit").append(commits[1]).append(path.removeFirstSegments(1));
            return new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), p.toString(), "parts=body", null);
        }
        if (scope.equals("Cached")) {
            IPath p = new Path("/gitapi/index").append(path.removeFirstSegments(1));
            return new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), p.toString(), null, null);
        }
        return new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), path.removeFirstSegments(1).makeAbsolute().toString(), null, null);
    }

    @PropertyDescription(name="Base")
    private URI getBaseLocation() throws URISyntaxException, IOException {
        IPath path = new Path(this.baseLocation.getPath()).removeFirstSegments(2);
        return this.getBaseLocation(this.baseLocation, this.db, path);
    }

    private URI getBaseLocation(URI location, Repository db, IPath path) throws URISyntaxException, IOException {
        String scope = path.segment(0);
        if (scope.contains("..")) {
            String[] commits = scope.split("\\.\\.");
            if (commits.length != 2) {
                throw new IllegalArgumentException(NLS.bind((String)"Illegal scope format, expected {old}..{new}, was {0}", (Object)scope));
            }
            ResolveMerger merger = new ResolveMerger(db){};
            String tip0 = GitUtils.decode(commits[0]);
            String tip1 = GitUtils.decode(commits[1]);
            merger.merge((AnyObjectId[])new ObjectId[]{db.resolve(tip0), db.resolve(tip1)});
            IPath p = new Path("/gitapi/commit").append(merger.getBaseCommitId().getName()).append(path.removeFirstSegments(1));
            return new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), p.toString(), "parts=body", null);
        }
        if (scope.equals("Cached")) {
            IPath p = new Path("/gitapi/commit").append("HEAD").append(path.removeFirstSegments(1));
            return new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), p.toString(), "parts=body", null);
        }
        IPath p = new Path("/gitapi/index").append(path.removeFirstSegments(1));
        return new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), p.toString(), null, null);
    }
}

