/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.logs.jobs;

import ch.qos.logback.classic.Logger;
import java.net.URI;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.tasks.TaskJob;
import org.eclipse.orion.server.logs.ILogService;
import org.eclipse.orion.server.logs.objects.LoggerResource;
import org.eclipse.osgi.util.NLS;

public class LoggerJob
extends TaskJob {
    private final ILogService logService;
    private final URI baseLocation;
    private final String loggerName;

    public LoggerJob(String userRunningTask, ILogService logService, URI baseLocation, String loggerName) {
        super(userRunningTask, false);
        this.logService = logService;
        this.baseLocation = baseLocation;
        this.loggerName = loggerName;
    }

    protected IStatus performJob() {
        try {
            Logger logger = this.logService.getLogger(this.loggerName);
            if (logger == null) {
                String msg = NLS.bind((String)"Logger not found: {0}", (Object)this.loggerName);
                return new ServerStatus(4, 404, msg, null);
            }
            LoggerResource loggerResource = new LoggerResource();
            loggerResource.setBaseLocation(this.baseLocation);
            loggerResource.setName(logger.getName());
            loggerResource.setLevel(logger.getLevel());
            loggerResource.setEffectiveLevel(logger.getEffectiveLevel());
            return new ServerStatus(Status.OK_STATUS, 200, loggerResource.toJSON());
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when looking for logger: {0}", (Object)this.loggerName);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }
}

