/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.servlets;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.orion.server.core.PreferenceHelper;

public class MonitoringUserFilter
implements Filter {
    private List<String> authorizedUsers;

    public void init(FilterConfig filterConfig) throws ServletException {
        String users = PreferenceHelper.getString((String)"orion.auth.log.service", null);
        if (users != null) {
            this.authorizedUsers = new ArrayList<String>();
            this.authorizedUsers.addAll(Arrays.asList(users.split(",")));
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (this.authorizedUsers == null) {
            return;
        }
        String login = httpRequest.getRemoteUser();
        if (login == null || !this.authorizedUsers.contains(login)) {
            return;
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

