/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.workspace;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.DirectoryWalker;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.metastore.WorkspaceInfo;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FileListDirectoryWalker
extends DirectoryWalker<File> {
    private File workspaceRoot;
    private boolean isRoot = true;
    private String workspacePath;
    private int workspaceRootSuffixLength;
    private String filter;
    private IFileStore workspaceHome;
    static final String SYNC_VERSION = "1.0";

    public FileListDirectoryWalker(WorkspaceInfo workspaceInfo) {
        this(workspaceInfo, null);
    }

    public FileListDirectoryWalker(WorkspaceInfo workspaceInfo, String filterPath) {
        this.init(workspaceInfo, filterPath);
    }

    private void init(WorkspaceInfo workspaceInfo, String filterPath) {
        String workspaceId = workspaceInfo.getUniqueId();
        this.filter = filterPath;
        IFileStore userHome = OrionConfiguration.getMetaStore().getUserHome(workspaceInfo.getUserId());
        this.workspaceHome = userHome.getChild(workspaceId.substring(workspaceId.indexOf(45) + 1));
        try {
            this.workspaceRoot = this.workspaceHome.toLocalFile(0, null);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        this.workspacePath = "/file/" + workspaceId;
        this.workspaceRootSuffixLength = this.workspaceRoot.getAbsolutePath().length();
    }

    protected void handleFile(File file, int depth, Collection<File> results) throws IOException {
        results.add(file);
    }

    protected boolean handleDirectory(File directory, int depth, Collection<File> results) throws IOException {
        if (!this.isRoot) {
            results.add(directory);
        } else {
            this.isRoot = false;
        }
        return true;
    }

    public JSONObject getFileList() {
        ArrayList files;
        block8: {
            files = new ArrayList();
            try {
                if (this.filter != null) {
                    IFileStore projHome = this.workspaceHome.getChild(this.filter);
                    try {
                        File projRoot = projHome.toLocalFile(0, null);
                        this.walk(projRoot, files);
                        break block8;
                    }
                    catch (CoreException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.walk(this.workspaceRoot, files);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        JSONObject json = new JSONObject();
        try {
            JSONArray jsonArray = new JSONArray();
            for (File file : files) {
                jsonArray.put((Object)this.toJSON(file, this.workspaceRootSuffixLength));
            }
            json.put("FileList", (Object)jsonArray);
            json.put("Timestamp", System.currentTimeMillis());
            json.put("SyncVersion", (Object)SYNC_VERSION);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return json;
    }

    private JSONObject toJSON(File file, int workspaceRootSuffixLength) throws JSONException {
        JSONObject json = new JSONObject();
        String filePath = file.getAbsolutePath().substring(workspaceRootSuffixLength);
        filePath = new Path(filePath).toPortableString();
        if (file.isFile()) {
            String sha = this.checkSum(file.getAbsolutePath());
            json.put("SHA", (Object)sha);
        } else if (!filePath.endsWith("/")) {
            filePath = String.valueOf(filePath) + "/";
        }
        json.put("Length", file.isFile() ? Long.toString(file.length()) : Integer.valueOf(file.list().length));
        try {
            json.put("Location", (Object)new URI("orion", null, String.valueOf(this.workspacePath) + filePath, null, null));
            json.put("LastModified", (Object)Long.toString(file.lastModified()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return json;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String checkSum(String path) {
        int bytesRead;
        FileInputStream stream = null;
        stream = new FileInputStream(path);
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        byte[] buffer = new byte[1024];
        while ((bytesRead = stream.read(buffer)) > 0) {
            digest.update(buffer, 0, bytesRead);
        }
        byte[] hashedBytes = digest.digest();
        String string = FileListDirectoryWalker.convertByteArrayToHexString(hashedBytes);
        if (stream == null) return string;
        try {
            stream.close();
            return string;
        }
        catch (IOException iOException) {}
        return string;
        catch (Exception exception) {
            try {
                if (stream == null) return "";
            }
            catch (Throwable throwable) {
                if (stream == null) throw throwable;
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                stream.close();
                return "";
            }
            catch (IOException iOException) {}
            return "";
        }
    }

    private static String convertByteArrayToHexString(byte[] arrayBytes) {
        StringBuffer stringBuffer = new StringBuffer();
        int i = 0;
        while (i < arrayBytes.length) {
            stringBuffer.append(Integer.toString((arrayBytes[i] & 0xFF) + 256, 16).substring(1));
            ++i;
        }
        return stringBuffer.toString();
    }
}

