/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.task.TaskJobHandler;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.tasks.IURIUnqualificationStrategy;
import org.eclipse.orion.server.core.tasks.TaskJob;
import org.eclipse.orion.server.git.BaseToCloneConverter;
import org.eclipse.orion.server.git.jobs.ListPullRequestsJob;
import org.eclipse.orion.server.git.servlets.AbstractGitHandler;
import org.eclipse.orion.server.servlets.JsonURIUnqualificationStrategy;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.json.JSONArray;
import org.json.JSONObject;

public class GitPullRequestHandlerV1
extends AbstractGitHandler {
    GitPullRequestHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        super(statusHandler);
    }

    @Override
    protected boolean handlePost(AbstractGitHandler.RequestInfo requestInfo) throws ServletException {
        HttpServletRequest request = requestInfo.request;
        HttpServletResponse response = requestInfo.response;
        Repository db = requestInfo.db;
        JSONObject credentials = requestInfo.getJSONRequest();
        try {
            String username = credentials.optString("GitSshUsername", "");
            String password = credentials.optString("GitSshPassword", "");
            String url = credentials.optString("GitUrl", db.getConfig().getString("remote", "origin", "url"));
            if (url != null) {
                Object cookie = request.getAttribute("SSOToken");
                String[] parsedUrl = GitPullRequestHandlerV1.parseSshGitUrl(url);
                String apiHost = GitPullRequestHandlerV1.getAPIHost(parsedUrl[0]);
                String user = parsedUrl[1];
                String project = parsedUrl[2];
                URI cloneLocation = BaseToCloneConverter.getCloneLocation(GitPullRequestHandlerV1.getURI((HttpServletRequest)request), BaseToCloneConverter.BRANCH_LIST);
                ListPullRequestsJob job = new ListPullRequestsJob(TaskJobHandler.getUserId((HttpServletRequest)request), url, cloneLocation, apiHost, user, project, username, password, cookie);
                return TaskJobHandler.handleTaskJob((HttpServletRequest)request, (HttpServletResponse)response, (TaskJob)job, (ServletResourceHandler)this.statusHandler, (IURIUnqualificationStrategy)JsonURIUnqualificationStrategy.ALL_NO_GIT);
            }
            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)new JSONArray(), (IURIUnqualificationStrategy)JsonURIUnqualificationStrategy.ALL_NO_GIT);
            return true;
        }
        catch (Exception ex) {
            String msg = "An error occured for pull request list command.";
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, msg, (Throwable)ex));
        }
    }

    public static String getAPIHost(String host) throws URISyntaxException {
        if (host.equals("github.com")) {
            return "https://api.github.com/";
        }
        return "https://" + host + "/api/v3/";
    }

    public static String[] parseSshGitUrl(String url) throws URISyntaxException {
        String user = "";
        String project = "";
        URIish uriish = new URIish(url);
        String[] scp = uriish.getPath().replaceFirst("^/", "").split("/", -1);
        if (scp.length == 2) {
            user = scp[0];
            project = uriish.getHumanishName();
        }
        return new String[]{uriish.getHost(), user, project};
    }
}

