/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.authentication.formoauth;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.orion.server.authentication.form.FormAuthHelper;
import org.eclipse.orion.server.authentication.formoauth.FormAuthenticationService;
import org.eclipse.orion.server.authentication.formoauth.ManageOAuthServlet;
import org.eclipse.orion.server.authentication.oauth.OAuthException;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.core.metastore.UserInfo;
import org.eclipse.orion.server.core.resources.Base64;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.Version;

public class FormAuthLoginServlet
extends HttpServlet {
    private FormAuthenticationService authenticationService;
    private ManageOAuthServlet manageOAuthServlet;
    private static final long serialVersionUID = 1L;

    public FormAuthLoginServlet(FormAuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
        this.manageOAuthServlet = new ManageOAuthServlet();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo;
        String string = pathInfo = req.getPathInfo() == null ? "" : req.getPathInfo();
        if (pathInfo.startsWith("/form")) {
            FormAuthHelper.LoginResult authResult = FormAuthHelper.performAuthentication(req, resp);
            if (authResult == FormAuthHelper.LoginResult.OK) {
                String versionString = req.getHeader("Orion-Version");
                Version version = versionString == null ? null : new Version(versionString);
                String xRequestedWith = req.getHeader("X-Requested-With");
                if (version == null && !"XMLHttpRequest".equals(xRequestedWith)) {
                    if (req.getParameter("redirect") != null && !req.getParameter("redirect").equals("")) {
                        resp.sendRedirect(req.getParameter("redirect"));
                    }
                } else {
                    resp.setHeader("Cache-Control", "no-cache");
                    resp.setStatus(200);
                    PrintWriter writer = resp.getWriter();
                    String uid = (String)req.getSession().getAttribute("user");
                    try {
                        JSONObject userJson = FormAuthHelper.getUserJson(uid, req.getContextPath());
                        writer.print(userJson.toString(2));
                        resp.setContentType("application/json");
                    }
                    catch (JSONException jSONException) {}
                }
                resp.flushBuffer();
            } else if (authResult == FormAuthHelper.LoginResult.BLOCKED) {
                this.displayError("Your account is not active. Please confirm your email before logging in.", req, resp);
            } else {
                this.displayError("Invalid user or password", req, resp);
            }
            return;
        }
        if (pathInfo.startsWith("/oauth")) {
            try {
                this.manageOAuthServlet.handleGetAndLogin(req, resp);
                resp.setStatus(200);
            }
            catch (OAuthException e) {
                this.displayError(e.getMessage(), req, resp);
            }
        }
        if (pathInfo.startsWith("/canaddusers")) {
            JSONObject jsonResp = new JSONObject();
            try {
                jsonResp.put("CanAddUsers", FormAuthHelper.canAddUsers());
                jsonResp.put("ForceEmail", FormAuthHelper.forceEmail());
                jsonResp.put("RegistrationURI", (Object)FormAuthHelper.registrationURI());
            }
            catch (JSONException jSONException) {}
            resp.setHeader("Cache-Control", "no-cache");
            resp.getWriter().print(jsonResp);
            resp.setContentType("application/json");
            return;
        }
        String user = req.getRemoteUser();
        if (user == null) {
            user = this.authenticationService.getAuthenticatedUser(req, resp);
        }
        if (user != null && !pathInfo.startsWith("/oauth")) {
            try {
                Cookie[] cookies;
                UserInfo userInfo = OrionConfiguration.getMetaStore().readUser(user);
                userInfo.setProperty("LastLoginTimestamp", new Long(System.currentTimeMillis()).toString());
                String cookieToCache = PreferenceHelper.getString((String)"orion.cookie.cached");
                if (cookieToCache != null && (cookies = req.getCookies()) != null) {
                    int i = 0;
                    while (i < cookies.length) {
                        if (cookieToCache.equals(cookies[i].getName()) && cookies[i].getValue() != null) {
                            userInfo.setProperty("/cookie/cached/" + cookieToCache, cookies[i].getValue().toString());
                        }
                        ++i;
                    }
                }
                OrionConfiguration.getMetaStore().updateUser(userInfo);
            }
            catch (CoreException e) {
                LogHelper.log((Throwable)e);
            }
            resp.setHeader("Cache-Control", "no-cache");
            resp.setStatus(200);
            try {
                JSONObject jsonResp = FormAuthHelper.getUserJson(user, req.getContextPath());
                resp.setContentType("application/json");
                resp.getWriter().print(jsonResp);
            }
            catch (JSONException jSONException) {
                this.displayError("An error occured when creating JSON object for logged in user", req, resp);
            }
            return;
        }
    }

    private void displayError(String error, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String versionString = req.getHeader("Orion-Version");
        Version version = versionString == null ? null : new Version(versionString);
        String xRequestedWith = req.getHeader("X-Requested-With");
        if (version == null && !"XMLHttpRequest".equals(xRequestedWith)) {
            String url = "/mixloginstatic/LoginWindow.html";
            if (req.getParameter("redirect") != null) {
                url = String.valueOf(url) + "?redirect=" + req.getParameter("redirect");
            }
            if (error == null) {
                error = "Invalid login";
            }
            url = String.valueOf(url) + (url.contains("?") ? "&" : "?");
            url = String.valueOf(url) + "error=" + new String(Base64.encode((byte[])error.getBytes()));
            resp.sendRedirect(url);
        } else {
            resp.setHeader("Cache-Control", "no-cache");
            resp.setStatus(401);
            PrintWriter writer = resp.getWriter();
            JSONObject jsonError = new JSONObject();
            try {
                jsonError.put("error", (Object)error);
                writer.print(jsonError);
                resp.setContentType("application/json");
            }
            catch (JSONException jSONException) {}
        }
        resp.flushBuffer();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo;
        String string = pathInfo = req.getPathInfo() == null ? "" : req.getPathInfo();
        if (pathInfo.startsWith("/oauth")) {
            this.doPost(req, resp);
            return;
        }
        RequestDispatcher rd = req.getRequestDispatcher("/mixlogin/login");
        rd.forward((ServletRequest)req, (ServletResponse)resp);
    }
}

