/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.objects.Route;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteRouteCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName = "Delete the route";
    private Route route;

    public DeleteRouteCommand(Target target, Route route) {
        super(target);
        this.route = route;
    }

    @Override
    protected ServerStatus _doIt() {
        try {
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            URI routeURI = targetURI.resolve("/v2/routes/" + this.route.getGuid());
            DeleteMethod deleteRouteMethod = new DeleteMethod(routeURI.toString());
            ServerStatus confStatus = HttpUtil.configureHttpMethod((HttpMethod)deleteRouteMethod, this.target.getCloud());
            if (!confStatus.isOK()) {
                return confStatus;
            }
            deleteRouteMethod.setQueryString("recursive=true");
            ServerStatus status = HttpUtil.executeMethod((HttpMethodBase)deleteRouteMethod);
            return status;
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }

    @Override
    protected IStatus validateParams() {
        return Status.OK_STATUS;
    }
}

