/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.utils;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.orion.server.cf.CFExtServiceHelper;
import org.eclipse.orion.server.cf.objects.Cloud;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.URLUtil;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetRegistry {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private Map<String, UserClouds> cloudMap = new HashMap<String, UserClouds>();

    public Target getDefaultTarget(String userId) {
        return this.getTarget(userId, null);
    }

    public Target getTarget(String userId, URL url) {
        UserClouds userClouds = this.getUserClouds(userId);
        return userClouds.getTarget(url);
    }

    public Cloud getCloud(String userId, URL url) {
        UserClouds userClouds = this.getUserClouds(userId);
        return userClouds.getCloud(url);
    }

    public void setDefaultTarget(String userId, Target target) {
        UserClouds userClouds = this.getUserClouds(userId);
        userClouds.setDefaulTarget(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserClouds getUserClouds(String userId) {
        Map<String, UserClouds> map = this.cloudMap;
        synchronized (map) {
            UserClouds userClouds = this.cloudMap.get(userId);
            if (userClouds == null) {
                userClouds = new UserClouds(userId);
                this.cloudMap.put(userId, userClouds);
            }
            return userClouds;
        }
    }

    private class DarkCloud
    extends Cloud {
        protected DarkCloud(String regionId, URL apiUrl, URL manageUrl, String userId) {
            super(regionId, apiUrl, manageUrl, userId);
        }
    }

    private class UserClouds {
        private String userId;
        private Map<String, Cloud> userCloudMap = new HashMap<String, Cloud>();
        private volatile Target defaultTarget;

        private UserClouds(String userId) {
            this.userId = userId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Cloud getCloud(URL url) {
            Cloud cloud;
            TargetRegistry.this.logger.debug("UserClouds: " + this.getInfo());
            url = URLUtil.normalizeURL(url);
            if (url == null || this.defaultTarget != null && url.equals(this.defaultTarget.getCloud().getUrl())) {
                return this.defaultTarget != null ? this.defaultTarget.getCloud() : null;
            }
            Map<String, Cloud> map = this.userCloudMap;
            synchronized (map) {
                cloud = this.userCloudMap.get(url.toString());
                if (cloud == null) {
                    CFExtServiceHelper helper = CFExtServiceHelper.getDefault();
                    cloud = helper != null && helper.getService() != null ? helper.getService().getCloud(this.userId, url) : new DarkCloud(null, url, null, this.userId);
                    if (cloud == null) {
                        Cloud someCloud = this.getConfigCloud();
                        cloud = someCloud != null && someCloud.getUrl().equals(url) ? someCloud : new DarkCloud(null, url, null, this.userId);
                    }
                    this.userCloudMap.put(url.toString(), cloud);
                }
            }
            this.setAuthToken(cloud);
            return cloud;
        }

        private Cloud getConfigCloud() {
            try {
                String cloudConf = (String)OrionConfiguration.getMetaStore().readUser(this.userId).getProperties().get("cm/configurations/org.eclipse.orion.client.cf.settings");
                JSONObject cloudConfJSON = new JSONObject(cloudConf);
                URL cloudUrl = URLUtil.normalizeURL(new URL(cloudConfJSON.getString("targetUrl")));
                return new DarkCloud(null, cloudUrl, URLUtil.normalizeURL(new URL(cloudConfJSON.getString("manageUrl"))), this.userId);
            }
            catch (Exception exception) {
                return null;
            }
        }

        private Target getTarget(URL url) {
            if ((url = URLUtil.normalizeURL(url)) == null) {
                return this.defaultTarget;
            }
            if (this.defaultTarget != null && url.toString().equals(this.defaultTarget.getCloud().getUrl().toString())) {
                return new Target(this.defaultTarget.getCloud());
            }
            Cloud cloud = this.getCloud(url);
            return new Target(cloud);
        }

        private void setDefaulTarget(Target target) {
            Cloud cloud = this.getCloud(target.getCloud().getUrl());
            Target newTarget = new Target(cloud);
            newTarget.setOrg(target.getOrg());
            newTarget.setSpace(target.getSpace());
            this.defaultTarget = newTarget;
        }

        private void setAuthToken(Cloud cloud) {
            CFExtServiceHelper helper = CFExtServiceHelper.getDefault();
            if (cloud.getAccessToken() == null && helper != null && helper.getService() != null) {
                cloud.setAccessToken(helper.getService().getToken(cloud));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getInfo() {
            StringBuffer buf = new StringBuffer();
            buf.append("userId: " + this.userId + "\n");
            Map<String, Cloud> map = this.userCloudMap;
            synchronized (map) {
                buf.append("clouds: " + this.userCloudMap.size() + "\n");
                for (Cloud cloud : this.userCloudMap.values()) {
                    buf.append(String.valueOf(cloud.getRegion()) + "(" + cloud.getUrl().toString() + ")" + "\n");
                }
            }
            return buf.toString();
        }
    }
}

