/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.authentication.oauth.google;

import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthAccessTokenResponse;
import org.apache.oltu.oauth2.common.OAuthProviderType;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.eclipse.orion.server.authentication.oauth.OAuthConsumer;
import org.eclipse.orion.server.authentication.oauth.OAuthException;
import org.eclipse.orion.server.authentication.oauth.OAuthParams;
import org.eclipse.orion.server.authentication.oauth.OAuthTokenResponse;
import org.eclipse.orion.server.authentication.oauth.google.GoogleOAuthConsumer;
import org.eclipse.orion.server.core.PreferenceHelper;

public class GoogleOAuthParams
extends OAuthParams {
    private static final OAuthProviderType PROVIDER_TYPE = OAuthProviderType.GOOGLE;
    private static final String RESPONSE_TYPE = "code";
    private static final String SCOPE = "openid email";
    private static final String OPEN_ID_PARAMETER = "openid.realm";
    private static final GrantType GRANT_TYPE = GrantType.AUTHORIZATION_CODE;
    private static final String CLIENT_KEY = "orion.oauth.google.client";
    private static final String CLIENT_SECRET = "orion.oauth.google.secret";
    private static final Class<? extends OAuthAccessTokenResponse> TOKEN_RESPONSE_CLASS = OAuthTokenResponse.class;
    private String client_key = null;
    private String client_secret = null;

    public GoogleOAuthParams(HttpServletRequest req, boolean login) throws OAuthException {
        super(req, login);
    }

    @Override
    public OAuthProviderType getProviderType() {
        return PROVIDER_TYPE;
    }

    @Override
    public String getClientKey() throws OAuthException {
        if (this.client_key == null) {
            this.client_key = PreferenceHelper.getString((String)CLIENT_KEY);
        }
        return this.client_key;
    }

    @Override
    public String getClientSecret() throws OAuthException {
        if (this.client_secret == null) {
            this.client_secret = PreferenceHelper.getString((String)CLIENT_SECRET);
        }
        return this.client_secret;
    }

    @Override
    public String getResponseType() {
        return RESPONSE_TYPE;
    }

    @Override
    public String getScope() {
        return SCOPE;
    }

    @Override
    public GrantType getGrantType() {
        return GRANT_TYPE;
    }

    @Override
    public Class<? extends OAuthAccessTokenResponse> getTokenResponseClass() {
        return TOKEN_RESPONSE_CLASS;
    }

    @Override
    public OAuthConsumer getNewOAuthConsumer(OAuthAccessTokenResponse oauthAccessTokenResponse) throws OAuthException {
        return new GoogleOAuthConsumer(oauthAccessTokenResponse, this.getRedirect());
    }

    @Override
    public void addAdditionsParams(OAuthClientRequest.AuthenticationRequestBuilder requestBuiler) throws OAuthException {
        try {
            URL currentURL = this.getCurrentURL();
            String realm = new URL(currentURL.getProtocol(), currentURL.getHost(), currentURL.getPort(), "").toString();
            requestBuiler.setParameter(OPEN_ID_PARAMETER, realm);
        }
        catch (MalformedURLException malformedURLException) {
            throw new OAuthException("An Error occured while building the request URL");
        }
    }
}

