/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.workspace.UserInfoResourceHandler;
import org.eclipse.orion.server.core.IOUtilities;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.metastore.ProjectInfo;
import org.eclipse.orion.server.core.metastore.UserInfo;
import org.eclipse.orion.server.core.metastore.WorkspaceInfo;
import org.eclipse.orion.server.core.tasks.IURIUnqualificationStrategy;
import org.eclipse.orion.server.git.servlets.AbstractGitHandler;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.orion.server.servlets.JsonURIUnqualificationStrategy;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GitTreeHandlerV1
extends AbstractGitHandler {
    GitTreeHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        super(statusHandler);
    }

    private JSONObject listEntry(String name, long timeStamp, boolean isDir, long length, URI location, String appendName) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("Name", (Object)name);
            jsonObject.put("LocalTimeStamp", timeStamp);
            jsonObject.put("Directory", isDir);
            jsonObject.put("Length", length);
            if (location != null) {
                if (isDir && !location.getPath().endsWith("/")) {
                    location = URIUtil.append((URI)location, (String)"");
                }
                if (appendName != null) {
                    if (!appendName.startsWith("/") && !location.getPath().endsWith("/")) {
                        appendName = "/" + appendName;
                    }
                    location = new URI(location.getScheme(), location.getAuthority(), String.valueOf(location.getPath()) + appendName, null, location.getFragment());
                    if (isDir) {
                        location = URIUtil.append((URI)location, (String)"");
                    }
                }
                jsonObject.put("Location", (Object)location);
                if (isDir) {
                    try {
                        jsonObject.put("ChildrenLocation", (Object)new URI(location.getScheme(), location.getAuthority(), location.getPath(), "depth=1", location.getFragment()));
                    }
                    catch (URISyntaxException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            JSONObject attributes = new JSONObject();
            attributes.put("ReadOnly", true);
            jsonObject.put("Attributes", (Object)attributes);
        }
        catch (JSONException jSONException) {
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return jsonObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isAccessAllowed(String userName, ProjectInfo webProject) {
        try {
            String workspaceId;
            WorkspaceInfo workspace;
            UserInfo user = OrionConfiguration.getMetaStore().readUser(userName);
            Iterator iterator = user.getWorkspaceIds().iterator();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                workspaceId = (String)iterator.next();
            } while ((workspace = OrionConfiguration.getMetaStore().readWorkspace(workspaceId)) == null || !workspace.getProjectNames().contains(webProject.getFullName()));
            return true;
        }
        catch (Exception e) {
            LogHelper.log((Throwable)e);
        }
        return false;
    }

    @Override
    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, String pathString) throws ServletException {
        Path path = pathString == null ? Path.EMPTY : new Path(pathString);
        int segmentCount = path.segmentCount();
        if (GitTreeHandlerV1.getMethod((HttpServletRequest)request) == ServletResourceHandler.Method.GET && (segmentCount == 0 || "workspace".equals(path.segment(0)) && path.segmentCount() == 2 || "file".equals(path.segment(0)) && path.segmentCount() == 2)) {
            URI baseLocation;
            UserInfo user;
            block8: {
                String userId = request.getRemoteUser();
                if (userId == null) {
                    this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 403, "User name not specified", null));
                    return false;
                }
                user = OrionConfiguration.getMetaStore().readUser(userId);
                baseLocation = new URI("orion", null, request.getServletPath(), null, null);
                baseLocation = URIUtil.append((URI)baseLocation, (String)"tree");
                baseLocation = URIUtil.append((URI)baseLocation, (String)"file");
                if (segmentCount != 0) break block8;
                OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)UserInfoResourceHandler.toJSON((UserInfo)user, (URI)baseLocation), (IURIUnqualificationStrategy)JsonURIUnqualificationStrategy.ALL_NO_GIT);
                return true;
            }
            try {
                WorkspaceInfo workspace = OrionConfiguration.getMetaStore().readWorkspace(path.segment(1));
                if (workspace != null) {
                    JSONArray children = new JSONArray();
                    for (String projectName : workspace.getProjectNames()) {
                        ProjectInfo project = OrionConfiguration.getMetaStore().readProject(workspace.getUniqueId(), projectName);
                        if (!this.isAccessAllowed(user.getUserName(), project)) continue;
                        IPath projectPath = GitUtils.pathFromProject(workspace, project);
                        Map<IPath, File> gitDirs = GitUtils.getGitDirs(projectPath, GitUtils.Traverse.GO_DOWN);
                        for (Map.Entry<IPath, File> entry : gitDirs.entrySet()) {
                            JSONObject repo = this.listEntry(entry.getKey().lastSegment(), 0L, true, 0L, baseLocation, entry.getKey().toPortableString());
                            children.put((Object)repo);
                        }
                    }
                    JSONObject result = this.listEntry(workspace.getFullName(), 0L, true, 0L, baseLocation, workspace.getUniqueId());
                    result.put("Id", (Object)workspace.getUniqueId());
                    result.put("Children", (Object)children);
                    OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result, (IURIUnqualificationStrategy)JsonURIUnqualificationStrategy.ALL_NO_GIT);
                    return true;
                }
            }
            catch (Exception e) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An error occurred while obtaining workspace data.", (Throwable)e));
            }
            return true;
        }
        return super.handleRequest(request, response, pathString);
    }

    @Override
    protected boolean handleGet(AbstractGitHandler.RequestInfo requestInfo) throws ServletException {
        HttpServletRequest request = requestInfo.request;
        HttpServletResponse response = requestInfo.response;
        String gitSegment = requestInfo.gitSegment;
        Repository repo = requestInfo.db;
        String pattern = requestInfo.relativePath;
        IPath filePath = requestInfo.filePath;
        String meta = request.getParameter("parts");
        RevWalk walk = null;
        TreeWalk treeWalk = null;
        Path filterPath = new Path(pattern);
        try {
            if (filterPath.segmentCount() == 0) {
                JSONArray children = new JSONArray();
                URI baseLocation = GitTreeHandlerV1.getURI((HttpServletRequest)request);
                List call = Git.wrap((Repository)repo).branchList().setListMode(ListBranchCommand.ListMode.ALL).call();
                for (Ref ref : call) {
                    String branchName = Repository.shortenRefName((String)ref.getName());
                    JSONObject branch = this.listEntry(branchName, 0L, true, 0L, baseLocation, GitUtils.encode(branchName));
                    children.put((Object)branch);
                }
                JSONObject result = this.listEntry(filePath.segment(0), 0L, true, 0L, baseLocation, null);
                result.put("Children", (Object)children);
                OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result, (IURIUnqualificationStrategy)JsonURIUnqualificationStrategy.ALL_NO_GIT);
                return true;
            }
            gitSegment = GitUtils.decode(filterPath.segment(0));
            filterPath = filterPath.removeFirstSegments(1);
            pattern = filterPath.toPortableString();
            ObjectId head = repo.resolve(gitSegment);
            if (head == null) {
                throw new Exception("Missing ref in git segment");
            }
            walk = new RevWalk(repo);
            RevCommit commit = walk.parseCommit((AnyObjectId)head);
            RevTree tree = commit.getTree();
            treeWalk = new TreeWalk(repo);
            treeWalk.addTree((AnyObjectId)tree);
            treeWalk.setRecursive(false);
            if (!pattern.equals("")) {
                PathFilter pathFilter = PathFilter.create((String)pattern);
                treeWalk.setFilter((TreeFilter)pathFilter);
            }
            JSONArray contents = new JSONArray();
            JSONObject result = null;
            ArrayList<JSONObject> parents = new ArrayList<JSONObject>();
            URI baseLocation = ServletResourceHandler.getURI((HttpServletRequest)request);
            Path basePath = new Path(baseLocation.getPath());
            Path tmp = new Path("/");
            int i = 0;
            while (i < 5) {
                tmp = tmp.append(basePath.segment(i));
                ++i;
            }
            URI cloneLocation = new URI(baseLocation.getScheme(), baseLocation.getAuthority(), tmp.toPortableString(), null, baseLocation.getFragment());
            JSONObject ref = this.listEntry(gitSegment, 0L, true, 0L, cloneLocation, GitUtils.encode(gitSegment));
            parents.add(ref);
            parents.add(this.listEntry(new Path(cloneLocation.getPath()).lastSegment(), 0L, true, 0L, cloneLocation, null));
            URI locationWalk = URIUtil.append((URI)cloneLocation, (String)GitUtils.encode(gitSegment));
            while (treeWalk.next()) {
                if (treeWalk.isSubtree()) {
                    if (treeWalk.getPathLength() > pattern.length()) {
                        String name = treeWalk.getNameString();
                        contents.put((Object)this.listEntry(name, 0L, true, 0L, locationWalk, name));
                    }
                    if (treeWalk.getPathLength() > pattern.length()) continue;
                    locationWalk = URIUtil.append((URI)locationWalk, (String)treeWalk.getNameString());
                    parents.add(0, this.listEntry(treeWalk.getNameString(), 0L, true, 0L, locationWalk, null));
                    treeWalk.enterSubtree();
                    continue;
                }
                ObjectId objId = treeWalk.getObjectId(0);
                ObjectLoader loader = repo.open((AnyObjectId)objId);
                long size = loader.getSize();
                if (treeWalk.getPathLength() == pattern.length()) {
                    if ("meta".equals(meta)) {
                        result = this.listEntry(treeWalk.getNameString(), 0L, false, 0L, locationWalk, treeWalk.getNameString());
                        continue;
                    }
                    boolean bl = this.getFileContents(request, response, repo, treeWalk, tree);
                    return bl;
                }
                String name = treeWalk.getNameString();
                contents.put((Object)this.listEntry(name, 0L, false, size, locationWalk, name));
            }
            if (result == null) {
                result = (JSONObject)parents.remove(0);
                result.put("Children", (Object)contents);
            }
            result.put("Parents", (Object)new JSONArray(parents));
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("ETag", "\"" + tree.getId().getName() + "\"");
            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
            return true;
        }
        catch (Exception e) {
            boolean bl = this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An error occured when requesting commit info.", (Throwable)e));
            return bl;
        }
        finally {
            if (walk != null) {
                walk.close();
            }
            if (treeWalk != null) {
                treeWalk.close();
            }
        }
    }

    private boolean getFileContents(HttpServletRequest request, HttpServletResponse response, Repository repo, TreeWalk treeWalk, RevTree tree) {
        block18: {
            ObjectStream stream = null;
            try {
                ObjectId objId = treeWalk.getObjectId(0);
                ObjectLoader loader = repo.open((AnyObjectId)objId);
                response.setHeader("Cache-Control", "no-cache");
                response.setHeader("ETag", "\"" + tree.getId().getName() + "\"");
                response.setContentType("application/octet-stream");
                stream = loader.openStream();
                IOUtilities.pipe((InputStream)stream, (OutputStream)response.getOutputStream(), (boolean)true, (boolean)false);
            }
            catch (MissingObjectException missingObjectException) {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                    break block18;
                }
                catch (IOException iOException) {}
                break block18;
            }
            catch (IOException iOException) {
                try {}
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException iOException2) {}
                    throw throwable;
                }
                try {
                    if (stream != null) {
                        stream.close();
                    }
                    break block18;
                }
                catch (IOException iOException3) {}
                break block18;
            }
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return true;
    }
}

