/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.logs;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.RollingPolicyBase;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.server.logs.ILogService;
import org.slf4j.LoggerFactory;

public class LogService
implements ILogService {
    @Override
    public List<Logger> getLoggers() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        return loggerContext.getLoggerList();
    }

    @Override
    public Logger getLogger(String name) {
        if (name == null) {
            return null;
        }
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        return loggerContext.getLogger(name);
    }

    @Override
    public List<FileAppender<ILoggingEvent>> getFileAppenders() {
        LinkedList<FileAppender<ILoggingEvent>> fileAppenders = new LinkedList<FileAppender<ILoggingEvent>>();
        for (Logger logger : this.getLoggers()) {
            Iterator index = logger.iteratorForAppenders();
            while (index.hasNext()) {
                Appender appender = (Appender)index.next();
                if (!(appender instanceof FileAppender)) continue;
                fileAppenders.add((FileAppender<ILoggingEvent>)((FileAppender)appender));
            }
        }
        return fileAppenders;
    }

    @Override
    public FileAppender<ILoggingEvent> getFileAppender(String name) {
        if (name == null) {
            return null;
        }
        for (Logger logger : this.getLoggers()) {
            Iterator index = logger.iteratorForAppenders();
            while (index.hasNext()) {
                Appender appender = (Appender)index.next();
                if (!(appender instanceof FileAppender) || !name.equals(appender.getName())) continue;
                return (FileAppender)appender;
            }
        }
        return null;
    }

    @Override
    public RollingFileAppender<ILoggingEvent> getRollingFileAppender(String name) {
        FileAppender<ILoggingEvent> fileAppender = this.getFileAppender(name);
        if (fileAppender == null) {
            return null;
        }
        if (fileAppender instanceof RollingFileAppender) {
            return (RollingFileAppender)fileAppender;
        }
        return null;
    }

    @Override
    public File[] getArchivedLogFiles(RollingFileAppender<ILoggingEvent> rollingFileAppender) {
        if (rollingFileAppender == null) {
            return null;
        }
        RollingPolicy rollingPolicy = rollingFileAppender.getRollingPolicy();
        if (rollingPolicy == null) {
            return null;
        }
        if (rollingPolicy instanceof RollingPolicyBase) {
            RollingPolicyBase policy = (RollingPolicyBase)rollingPolicy;
            String fileNamePattern = policy.getFileNamePattern();
            Context context = rollingFileAppender.getContext();
            File dir = null;
            FileNamePattern pattern = new FileNamePattern(fileNamePattern, context);
            Path path = new Path(pattern.toRegex(new Date()));
            if (!path.isAbsolute()) {
                dir = new File(".");
            } else {
                dir = path.removeLastSegments(1).toFile();
                Path p = new Path(fileNamePattern);
                pattern = new FileNamePattern(p.lastSegment(), context);
            }
            final String patternRegex = pattern.toRegex();
            File[] files = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.matches(patternRegex);
                }
            });
            return files;
        }
        return null;
    }

    @Override
    public File getArchivedLogFile(RollingFileAppender<ILoggingEvent> rollingFileAppender, String logFileName) {
        if (rollingFileAppender == null || logFileName == null) {
            return null;
        }
        File[] archvieLogFiles = this.getArchivedLogFiles(rollingFileAppender);
        if (archvieLogFiles == null) {
            return null;
        }
        File[] fileArray = archvieLogFiles;
        int n = archvieLogFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File logFile = fileArray[n2];
            if (logFileName.equals(logFile.getName())) {
                return logFile;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public List<RollingFileAppender<ILoggingEvent>> getRollingFileAppenders() {
        LinkedList<RollingFileAppender<ILoggingEvent>> rollingFileAppenders = new LinkedList<RollingFileAppender<ILoggingEvent>>();
        for (Logger logger : this.getLoggers()) {
            Iterator index = logger.iteratorForAppenders();
            while (index.hasNext()) {
                Appender appender = (Appender)index.next();
                if (!(appender instanceof RollingFileAppender)) continue;
                rollingFileAppenders.add((RollingFileAppender<ILoggingEvent>)((RollingFileAppender)appender));
            }
        }
        return rollingFileAppenders;
    }
}

