/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetServiceCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String serviceGuid;
    private String commandName;

    public GetServiceCommand(Target target, String serviceGuid) {
        super(target);
        this.serviceGuid = serviceGuid;
        this.commandName = "Get service info";
    }

    @Override
    protected ServerStatus _doIt() {
        try {
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            URI serviceInstanceURI = targetURI.resolve("/v2/services/" + this.serviceGuid);
            GetMethod getServiceMethod = new GetMethod(serviceInstanceURI.toString());
            ServerStatus confStatus = HttpUtil.configureHttpMethod((HttpMethod)getServiceMethod, this.target.getCloud());
            if (!confStatus.isOK()) {
                return confStatus;
            }
            ServerStatus getStatus = HttpUtil.executeMethod((HttpMethodBase)getServiceMethod);
            if (!getStatus.isOK()) {
                return getStatus;
            }
            JSONObject service = getStatus.getJsonData();
            return new ServerStatus(Status.OK_STATUS, 200, service);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }
}

