/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ExpiryCache<T> {
    Map<Object, Expirable<T>> cache = Collections.synchronizedMap(new HashMap());
    private int maxSize;
    private int expires_ms;

    public ExpiryCache(int maxSize, int expires_ms) {
        this.maxSize = maxSize;
        this.expires_ms = expires_ms;
    }

    public T get(Object key) {
        Expirable<T> expirable = this.cache.get(key);
        if (expirable != null) {
            if (expirable.valid()) {
                return expirable.value;
            }
            this.cache.remove(key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object key, T value) {
        Map<Object, Expirable<T>> map = this.cache;
        synchronized (map) {
            if (this.cache.size() > this.maxSize) {
                Iterator<Expirable<T>> it = this.cache.values().iterator();
                while (it.hasNext()) {
                    Expirable<T> expirable = it.next();
                    if (expirable.valid()) continue;
                    it.remove();
                }
                if (this.cache.size() > this.maxSize) {
                    this.cache.clear();
                }
            }
            this.cache.put(key, new Expirable<T>(value, System.currentTimeMillis() + (long)this.expires_ms));
        }
    }

    public void remove(Object key) {
        this.cache.remove(key);
    }

    static class Expirable<T> {
        T value;
        long expires;

        public Expirable(T value, long expires) {
            this.value = value;
            this.expires = expires;
        }

        public boolean valid() {
            return System.currentTimeMillis() < this.expires;
        }
    }
}

