/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.servlets;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class WelcomeFileFilter
implements Filter {
    private static final String WELCOME_FILE_NAME = "index.html";
    private final List<String> includes = new ArrayList<String>();
    private final List<String> excludes = new ArrayList<String>();

    public void init(FilterConfig filterConfig) throws ServletException {
        String excludesParameter;
        String includesParameter = filterConfig.getInitParameter("includes");
        if (includesParameter != null) {
            StringTokenizer tokenizer = new StringTokenizer(includesParameter, ",", false);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                this.includes.add(token);
            }
        }
        if ((excludesParameter = filterConfig.getInitParameter("excludes")) != null) {
            StringTokenizer tokenizer = new StringTokenizer(excludesParameter, ",", false);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                this.excludes.add(token);
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        final HttpServletRequest httpRequest = (HttpServletRequest)request;
        final String requestPath = String.valueOf(httpRequest.getServletPath()) + (httpRequest.getPathInfo() == null ? "" : httpRequest.getPathInfo());
        if (requestPath.endsWith("/") && this.isIncluded(requestPath) && !this.isExcluded(requestPath)) {
            response = new HttpServletResponseWrapper((HttpServletResponse)response){

                private boolean handleWelcomeFile(int sc) {
                    if (sc == 404 || sc == 403) {
                        try {
                            httpRequest.getRequestDispatcher(String.valueOf(requestPath) + WelcomeFileFilter.WELCOME_FILE_NAME).forward((ServletRequest)httpRequest, this.getResponse());
                            return true;
                        }
                        catch (Exception exception) {}
                    }
                    return false;
                }

                public void sendError(int sc) throws IOException {
                    if (!this.handleWelcomeFile(sc)) {
                        super.sendError(sc);
                    }
                }

                public void sendError(int sc, String msg) throws IOException {
                    if (!this.handleWelcomeFile(sc)) {
                        super.sendError(sc, msg);
                    }
                }

                public void setContentLength(int len) {
                    if (len == 0) {
                        this.handleWelcomeFile(404);
                    } else {
                        super.setContentLength(len);
                    }
                }

                public void setStatus(int sc) {
                    if (!this.handleWelcomeFile(sc)) {
                        super.setStatus(sc);
                    }
                }

                public void setStatus(int sc, String sm) {
                    if (!this.handleWelcomeFile(sc)) {
                        super.setStatus(sc, sm);
                    }
                }
            };
        }
        chain.doFilter(request, response);
    }

    private boolean isIncluded(String requestPath) {
        return this.includes.isEmpty() || this.includes.contains(requestPath);
    }

    private boolean isExcluded(String requestPath) {
        return this.excludes.contains(requestPath);
    }

    public void destroy() {
    }
}

