/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.authentication.oauth.google;

import org.apache.oltu.oauth2.client.response.OAuthAccessTokenResponse;
import org.eclipse.orion.server.authentication.oauth.OAuthConsumer;
import org.eclipse.orion.server.authentication.oauth.OAuthException;
import org.eclipse.orion.server.core.resources.Base64;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleOAuthConsumer
extends OAuthConsumer {
    private static final String TOKEN_PARAMETER = "id_token";
    private static final String ID_PARAMETER = "sub";
    private static final String PROVIDER_PARAMETER = "iss";
    private static final String EMAIL_PARAMETER = "email";
    private static final String EMAIL_VERIFIED_PARAMETER = "email_verified";
    private static final String OPEN_ID_PARAMETER = "openid_id";
    private String userId;
    private String provider;
    private String openid_id;
    private String email;
    private boolean email_verified;

    public GoogleOAuthConsumer(OAuthAccessTokenResponse oauthAccessTokenResponse, String redirect) throws OAuthException {
        super(oauthAccessTokenResponse, redirect);
        try {
            JSONObject json = new JSONObject(oauthAccessTokenResponse.getBody());
            String jwt = json.getString(TOKEN_PARAMETER);
            this.parseToken(jwt);
        }
        catch (JSONException e) {
            throw new OAuthException(e);
        }
    }

    private void parseToken(String jwt) throws OAuthException {
        JSONObject jsonClaim;
        String[] sections = jwt.split("\\.");
        if (sections.length != 3) {
            throw new OAuthException("An error occured while authenticating");
        }
        String claim = sections[1];
        int buffer = 4 - claim.length() % 4;
        if (buffer == 3) {
            throw new OAuthException("An error occured while authenticating");
        }
        int i = 0;
        while (i < buffer && buffer != 4) {
            claim = String.valueOf(claim) + "=";
            ++i;
        }
        String decodedClaim = new String(Base64.decode((byte[])claim.getBytes()));
        try {
            jsonClaim = new JSONObject(decodedClaim);
            this.userId = jsonClaim.getString(ID_PARAMETER);
            this.provider = jsonClaim.getString(PROVIDER_PARAMETER);
            this.openid_id = jsonClaim.optString(OPEN_ID_PARAMETER, null);
        }
        catch (JSONException e) {
            throw new OAuthException(e);
        }
        this.email = "";
        this.email_verified = false;
        try {
            this.email = jsonClaim.getString(EMAIL_PARAMETER);
            this.email_verified = jsonClaim.getBoolean(EMAIL_VERIFIED_PARAMETER);
        }
        catch (JSONException jSONException) {}
    }

    @Override
    public String getIdentifier() {
        return String.valueOf(this.provider) + "/" + this.userId;
    }

    @Override
    public String getOpenidIdentifier() {
        return this.openid_id;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public String getUsername() {
        return this.getEmail() == null ? null : this.getEmail().split("@")[0];
    }

    @Override
    public boolean isEmailVerifiecd() {
        return this.email_verified;
    }
}

