/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.servlets;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ContentTypeFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String requestURI;
        String contentType;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        chain.doFilter(request, response);
        if (httpResponse.getStatus() != 204 && (contentType = httpResponse.getContentType()) == null && (requestURI = httpRequest.getRequestURI()) != null) {
            String[] pathInfoParts = requestURI.split("\\/");
            if (pathInfoParts.length == 0) {
                return;
            }
            String filename = pathInfoParts[pathInfoParts.length - 1];
            if (filename.equals("defaults.pref") || filename.endsWith(".json") || filename.endsWith(".launch")) {
                httpResponse.setContentType("application/json; charset=UTF-8");
            } else if (filename.endsWith(".md") || filename.endsWith(".yml")) {
                httpResponse.setContentType("text/plain;charset=UTF-8");
            } else if (filename.endsWith(".css")) {
                httpResponse.setContentType("application/css");
            } else if (filename.endsWith(".js")) {
                httpResponse.setContentType("application/x-javascript; charset=UTF-8");
            } else if (filename.endsWith(".woff")) {
                httpResponse.setContentType("application/font-woff");
            } else {
                String mimeType = httpRequest.getServletContext().getMimeType(filename);
                if (mimeType != null) {
                    String newContentType = String.valueOf(mimeType) + "; charset=UTF-8";
                    httpResponse.setContentType(newContentType);
                } else {
                    httpResponse.setContentType("text/plain;charset=UTF-8");
                }
            }
        }
    }

    public void destroy() {
    }
}

