/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.servlets;

import java.io.IOException;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CacheFilter
implements Filter {
    private static final Pattern maxAgePattern = Pattern.compile("^max-age *= *(\\d+)$");
    private String directives;
    private int maxAge = -1;
    private Pattern includeMatches;
    private Pattern excludeMatches;

    public void init(FilterConfig filterConfig) throws ServletException {
        String excludeMatchesParam;
        String includeMatchesParam;
        this.directives = filterConfig.getInitParameter("directives");
        if (this.directives == null) {
            throw new IllegalArgumentException("Cache-Control directives parmater cannot be empty");
        }
        StringTokenizer tokenizer = new StringTokenizer(this.directives, ",", false);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            Matcher matcher = maxAgePattern.matcher(token);
            if (!matcher.matches()) continue;
            this.maxAge = Integer.parseInt(matcher.group(1));
            if (this.maxAge >= 0) break;
            this.maxAge = 0;
            break;
        }
        if ((includeMatchesParam = filterConfig.getInitParameter("includeMatches")) != null) {
            this.includeMatches = Pattern.compile(includeMatchesParam);
        }
        if ((excludeMatchesParam = filterConfig.getInitParameter("excludeMatches")) != null) {
            this.excludeMatches = Pattern.compile(excludeMatchesParam);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String requestPath = httpRequest.getRequestURI().substring(httpRequest.getContextPath().length());
        if (!(this.includeMatches != null && !this.includeMatches.matcher(requestPath).matches() || this.excludeMatches != null && this.excludeMatches.matcher(requestPath).matches())) {
            if (this.maxAge != -1) {
                httpResponse.setDateHeader("Expires", System.currentTimeMillis() + (long)(this.maxAge * 1000));
            }
            httpResponse.setHeader("Cache-Control", this.directives);
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

