/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.objects;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.orion.server.core.resources.JSONSerializer;
import org.eclipse.orion.server.core.resources.Property;
import org.eclipse.orion.server.core.resources.ResourceShape;
import org.eclipse.orion.server.core.resources.Serializer;
import org.eclipse.orion.server.core.resources.annotations.PropertyDescription;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class GitObject {
    private static final ResourceShape DEFAULT_RESOURCE_SHAPE = new ResourceShape();
    protected Serializer<JSONObject> jsonSerializer;
    protected URI cloneLocation;
    protected Repository db;
    private StoredConfig cfg;

    private GitObject() {
        Property[] defaultProperties = new Property[]{new Property("Location"), new Property("CloneLocation")};
        DEFAULT_RESOURCE_SHAPE.setProperties(defaultProperties);
        this.jsonSerializer = new JSONSerializer();
    }

    GitObject(URI cloneLocation, Repository db) {
        this();
        this.cloneLocation = cloneLocation;
        this.db = db;
    }

    StoredConfig getConfig() {
        if (this.cfg == null) {
            this.cfg = this.db.getConfig();
        }
        return this.cfg;
    }

    @PropertyDescription(name="Location")
    protected abstract URI getLocation() throws URISyntaxException;

    @PropertyDescription(name="CloneLocation")
    public URI getCloneLocation() {
        return this.cloneLocation;
    }

    public JSONObject toJSON() throws JSONException, URISyntaxException, IOException, CoreException {
        return (JSONObject)this.jsonSerializer.serialize((Object)this, DEFAULT_RESOURCE_SHAPE);
    }
}

