/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.oauth2.common.utils;

import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONStringer;
import org.json.JSONTokener;

public final class JSONUtils {
    public static String buildJSON(Map<String, Object> params) throws JSONException {
        JSONStringer stringer = new JSONStringer();
        stringer.object();
        for (Map.Entry<String, Object> param : params.entrySet()) {
            if (param.getKey() == null || "".equals(param.getKey()) || param.getValue() == null || "".equals(param.getValue())) continue;
            stringer.key(param.getKey()).value(param.getValue());
        }
        return stringer.endObject().toString();
    }

    public static Map<String, Object> parseJSON(String jsonBody) throws JSONException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        JSONTokener x = new JSONTokener(jsonBody);
        if (x.nextClean() != '{') {
            throw new IllegalArgumentException(String.format("String '%s' is not a valid JSON object representation, a JSON object text must begin with '{'", jsonBody));
        }
        block8: while (true) {
            Object[] value;
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    throw new IllegalArgumentException(String.format("String '%s' is not a valid JSON object representation, a JSON object text must end with '}'", jsonBody));
                }
                case '}': {
                    return params;
                }
            }
            x.back();
            String key = x.nextValue().toString();
            c = x.nextClean();
            if (c == '=') {
                if (x.next() != '>') {
                    x.back();
                }
            } else if (c != ':') {
                throw new IllegalArgumentException(String.format("String '%s' is not a valid JSON object representation, expected a ':' after the key '%s'", jsonBody, key));
            }
            if ((value = x.nextValue()) != null) {
                if (value instanceof JSONArray) {
                    JSONArray array = (JSONArray)value;
                    Object[] values = new Object[array.length()];
                    int i = 0;
                    while (i < array.length()) {
                        values[i] = array.get(i);
                        ++i;
                    }
                    value = values;
                }
                params.put(key, value);
            }
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == '}') {
                        return params;
                    }
                    x.back();
                    continue block8;
                }
                case '}': {
                    return params;
                }
            }
            break;
        }
        throw new IllegalArgumentException("Expected a ',' or '}'");
    }
}

