/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.sftpfile;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.internal.server.sftpfile.AuthCoreException;
import org.eclipse.orion.internal.server.sftpfile.SynchronizedChannel;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelCache {
    private static final long CACHE_TIMEOUT = 60000L;
    private static SynchronizedChannel cache;
    private static URI cacheHost;
    private static long cacheExpiry;

    private static void closeChannel() {
        URI hostToClose = cacheHost;
        SynchronizedChannel channelToClose = cache;
        cache = null;
        cacheHost = null;
        if (channelToClose == null) {
            return;
        }
        try {
            channelToClose.disconnect();
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"Failure closing connection to {0}", (Object)hostToClose, (Object)e.getMessage());
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.servlets", msg, (Throwable)e));
        }
    }

    public static synchronized SynchronizedChannel getChannel(URI host) throws CoreException {
        Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.sftp");
        if (ChannelCache.isCacheAlive(host, logger)) {
            return cache;
        }
        ChannelCache.closeChannel();
        cache = ChannelCache.openChannel(host, logger);
        cacheHost = host;
        return cache;
    }

    private static boolean isCacheAlive(URI host, Logger logger) {
        if (cacheHost == null) {
            return false;
        }
        if (!cacheHost.equals(host)) {
            return false;
        }
        if (!cache.isConnected()) {
            return false;
        }
        if (System.currentTimeMillis() > cacheExpiry) {
            if (logger.isInfoEnabled()) {
                logger.info("Cache expired: " + host);
            }
            return false;
        }
        return true;
    }

    public static synchronized void flush(URI host) {
        if (host != null && host.equals(cacheHost)) {
            ChannelCache.closeChannel();
        }
    }

    private static SynchronizedChannel openChannel(URI host, Logger logger) throws CoreException {
        String user;
        String[] userParts;
        if (logger.isInfoEnabled()) {
            logger.info("Opening channel to: " + host);
        }
        JSch jsch = new JSch();
        int port = host.getPort();
        if (port < 0) {
            port = 22;
        }
        String[] stringArray = userParts = (user = host.getUserInfo()) != null ? user.split(":") : null;
        if (userParts == null || userParts.length != 2) {
            throw ChannelCache.authFail(host);
        }
        try {
            Session session = jsch.getSession(userParts[0], host.getHost(), port);
            String password = userParts[1];
            session.setPassword(password);
            session.setConfig("StrictHostKeyChecking", "no");
            session.connect();
            ChannelSftp channel = (ChannelSftp)session.openChannel("sftp");
            channel.connect();
            cacheExpiry = System.currentTimeMillis() + 60000L;
            return new SynchronizedChannel(channel);
        }
        catch (Exception e) {
            if ("Auth fail".equals(e.getMessage())) {
                throw ChannelCache.authFail(host);
            }
            String msg = NLS.bind((String)"Failure connecting to {0}", (Object)host, (Object)e.getMessage());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.servlets", msg, (Throwable)e));
        }
    }

    private static CoreException authFail(URI host) {
        return new AuthCoreException(host.getHost());
    }
}

