/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.file;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.file.GenericFileHandler;
import org.eclipse.orion.internal.server.servlets.file.ServletFileStoreHandler;
import org.eclipse.orion.server.core.IOUtilities;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.resources.UniversalUniqueIdentifier;
import org.eclipse.orion.server.servlets.JsonURIUnqualificationStrategy;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class FileHandlerV1
extends GenericFileHandler {
    final ServletResourceHandler<IStatus> statusHandler;
    private static final String EOL = "\r\n";

    FileHandlerV1(ServletResourceHandler<IStatus> statusHandler, ServletContext context) {
        super(context);
        this.statusHandler = statusHandler;
    }

    protected void appendGetMetadata(HttpServletRequest request, HttpServletResponse response, Writer responseWriter, IFileStore file) throws IOException, NoSuchAlgorithmException, JSONException, CoreException {
        JSONObject metadata = this.getMetadata(request, file);
        response.setHeader("ETag", metadata.getString("ETag"));
        response.setHeader("Cache-Control", "no-cache");
        OrionServlet.decorateResponse(request, metadata, JsonURIUnqualificationStrategy.ALL);
        responseWriter.append(metadata.toString());
    }

    protected void handleGetMetadata(HttpServletRequest request, HttpServletResponse response, IFileStore file) throws IOException, NoSuchAlgorithmException, JSONException, CoreException {
        JSONObject metadata = this.getMetadata(request, file);
        response.setHeader("ETag", metadata.getString("ETag"));
        OrionServlet.writeJSONResponse(request, response, metadata);
    }

    private JSONObject getMetadata(HttpServletRequest request, IFileStore file) throws CoreException, NoSuchAlgorithmException, IOException, JSONException {
        JSONObject metadata = ServletFileStoreHandler.toJSON(file, file.fetchInfo(0, null), FileHandlerV1.getURI(request));
        metadata.put("ETag", (Object)FileHandlerV1.generateFileETag(file));
        return metadata;
    }

    private void handleMultiPartGet(HttpServletRequest request, HttpServletResponse response, IFileStore file) throws IOException, CoreException, NoSuchAlgorithmException, JSONException {
        String boundary = this.createBoundaryString();
        response.setHeader("Accept-Patch", "application/json-patch; charset=UTF-8");
        response.setHeader("Content-Type", "multipart/related; boundary=\"" + boundary + '\"');
        ServletOutputStream outputStream = response.getOutputStream();
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");
        out.write("--" + boundary + EOL);
        out.write("Content-Type: application/json\r\n\r\n");
        this.appendGetMetadata(request, response, out, file);
        out.write("\r\n--" + boundary + EOL);
        out.write(EOL);
        ((Writer)out).flush();
        IOUtilities.pipe((InputStream)file.openInputStream(0, null), (OutputStream)outputStream, (boolean)true, (boolean)false);
        out.write("\r\n--" + boundary + EOL);
        ((Writer)out).flush();
    }

    String createBoundaryString() {
        return new UniversalUniqueIdentifier().toBase64String();
    }

    private void handlePutContents(HttpServletRequest request, ServletInputStream requestStream, HttpServletResponse response, IFileStore file) throws IOException, CoreException, NoSuchAlgorithmException, JSONException {
        String source = request.getParameter("source");
        if (!file.getParent().fetchInfo().exists()) {
            file.getParent().mkdir(0, null);
        }
        if (source != null) {
            IOUtilities.pipe((InputStream)new URL(source).openStream(), (OutputStream)file.openOutputStream(0, null), (boolean)true, (boolean)true);
        } else {
            IOUtilities.pipe((InputStream)requestStream, (OutputStream)file.openOutputStream(0, null), (boolean)false, (boolean)true);
        }
        this.handleGetMetadata(request, response, file);
    }

    private void handlePatchContents(HttpServletRequest request, BufferedReader requestReader, HttpServletResponse response, IFileStore file) throws IOException, CoreException, NoSuchAlgorithmException, JSONException, ServletException {
        String contents;
        char firstChar;
        JSONObject changes = OrionServlet.readJSONRequest(request);
        InputStreamReader fileReader = new InputStreamReader(file.openInputStream(0, null));
        StringWriter oldFile = new StringWriter();
        IOUtilities.pipe((Reader)fileReader, (Writer)oldFile, (boolean)true, (boolean)false);
        StringBuffer oldContents = oldFile.getBuffer();
        if (oldContents.length() > 0 && ((firstChar = oldContents.charAt(0)) == '\ufeff' || firstChar == '\ufffe')) {
            oldContents.replace(0, 1, "");
        }
        JSONArray changeList = changes.getJSONArray("diff");
        int i = 0;
        while (i < changeList.length()) {
            JSONObject change = changeList.getJSONObject(i);
            long start = change.getLong("start");
            long end = change.getLong("end");
            String text = change.getString("text");
            oldContents.replace((int)start, (int)end, text);
            ++i;
        }
        String newContents = oldContents.toString();
        boolean failed = false;
        if (changes.has("contents") && !newContents.equals(contents = changes.getString("contents"))) {
            failed = true;
            newContents = contents;
        }
        OutputStreamWriter fileWriter = new OutputStreamWriter(file.openOutputStream(0, null), "UTF-8");
        IOUtilities.pipe((Reader)new StringReader(newContents), (Writer)fileWriter, (boolean)false, (boolean)true);
        if (failed) {
            this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 406, "Bad File Diffs. Please paste this content in a bug report: \u00a0\u00a0 \t" + changes.toString(), null));
            return;
        }
        this.handleGetMetadata(request, response, file);
    }

    private void handleMultiPartPut(HttpServletRequest request, HttpServletResponse response, IFileStore file) throws IOException, CoreException, JSONException, NoSuchAlgorithmException {
        String line;
        String typeHeader = request.getHeader("Content-Type");
        String boundary = typeHeader.substring(typeHeader.indexOf("boundary=\"") + 10, typeHeader.length() - 1);
        ServletInputStream requestStream = request.getInputStream();
        BufferedReader requestReader = new BufferedReader(new InputStreamReader((InputStream)requestStream, "UTF-8"));
        this.handlePutMetadata(requestReader, boundary, file);
        HashMap<String, String> contentHeaders = new HashMap<String, String>();
        while ((line = requestReader.readLine()) != null && line.length() > 0) {
            String[] header = line.split(":");
            if (header.length != 2) continue;
            contentHeaders.put(header[0], header[1]);
        }
        this.handlePutContents(request, requestStream, response, file);
    }

    private void handlePutMetadata(BufferedReader reader, String boundary, IFileStore file) throws IOException, CoreException, JSONException {
        String line;
        StringBuffer buf = new StringBuffer();
        while ((line = reader.readLine()) != null && !line.equals(boundary)) {
            buf.append(line);
        }
        FileInfo info = (FileInfo)file.fetchInfo(0, null);
        ServletFileStoreHandler.copyJSONToFileInfo(new JSONObject(buf.toString()), info);
        file.putInfo((IFileInfo)info, 1024, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, IFileStore file) throws ServletException {
        long time = System.currentTimeMillis();
        try {
            String fileETag = FileHandlerV1.generateFileETag(file);
            if (this.handleIfMatchHeader(request, response, fileETag)) {
                return true;
            }
            if (this.handleIfNoneMatchHeader(request, response, fileETag)) {
                return true;
            }
            String parts = IOUtilities.getQueryParameter((HttpServletRequest)request, (String)"parts");
            if (parts == null || "body".equals(parts)) {
                switch (FileHandlerV1.getMethod(request)) {
                    case DELETE: {
                        file.delete(0, null);
                        return true;
                    }
                    case PUT: {
                        this.handlePutContents(request, request.getInputStream(), response, file);
                        return true;
                    }
                    case POST: {
                        if (!"PATCH".equals(request.getHeader("X-HTTP-Method-Override"))) return true;
                        this.handlePatchContents(request, request.getReader(), response, file);
                        return true;
                    }
                }
                boolean bl = this.handleFileContents(request, response, file);
                return bl;
            }
            if ("meta".equals(parts)) {
                switch (FileHandlerV1.getMethod(request)) {
                    case GET: {
                        this.handleGetMetadata(request, response, file);
                        return true;
                    }
                    case PUT: {
                        this.handlePutMetadata(request.getReader(), null, file);
                        response.setStatus(204);
                        return true;
                    }
                }
                return false;
            }
            if (!"meta,body".equals(parts)) {
                if (!"body,meta".equals(parts)) return false;
            }
            switch (FileHandlerV1.getMethod(request)) {
                case GET: {
                    this.handleMultiPartGet(request, response, file);
                    return true;
                }
                case PUT: {
                    this.handleMultiPartPut(request, response, file);
                    return true;
                }
            }
            return false;
        }
        catch (JSONException e) {
            boolean bl = this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 400, "Syntax error in request", (Throwable)e));
            return bl;
        }
        catch (Exception e) {
            if (this.handleAuthFailure(request, response, e)) return false;
            throw new ServletException(NLS.bind((String)"Error retrieving file: {0}", (Object)file), (Throwable)e);
        }
        finally {
            response.addHeader("ServerTime", "" + (System.currentTimeMillis() - time));
        }
    }
}

