/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.loggregator;

import com.google.protobuf.InvalidProtocolBufferException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketFrame;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.orion.server.cf.loggregator.LoggregatorListener;
import org.eclipse.orion.server.cf.loggregator.LoggregatorMessage;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSocket(maxTextMessageSize=65536)
public class LoggregatorSocket {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private final CountDownLatch closeLatch = new CountDownLatch(1);
    private LoggregatorListener listener;

    public LoggregatorSocket(LoggregatorListener listener) {
        this.listener = listener;
    }

    public boolean awaitClose(int duration, TimeUnit unit) throws InterruptedException {
        return this.closeLatch.await(duration, unit);
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        this.logger.debug(NLS.bind((String)"Connection closed: {0} - {1}", (Object)statusCode, (Object)reason));
        this.closeLatch.countDown();
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        this.logger.debug(NLS.bind((String)"Connected: {0}", (Object)session));
    }

    @OnWebSocketMessage
    public void onMessage(String msg) {
        this.logger.debug(NLS.bind((String)"Got message: {0}", (Object)msg));
    }

    @OnWebSocketFrame
    public void onFrame(Frame frame) {
        try {
            if (frame == null || frame.getPayload() == null) {
                return;
            }
            LoggregatorMessage.Message message = LoggregatorMessage.Message.parseFrom(frame.getPayload().array());
            this.listener.add(message);
        }
        catch (InvalidProtocolBufferException e) {
            this.logger.error("Error while receiving socket frame", (Throwable)e);
        }
        catch (Throwable t) {
            this.logger.error("Error while receiving socket frame", t);
        }
    }
}

