/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import java.net.URI;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.TagCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.task.TaskJobHandler;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.tasks.IURIUnqualificationStrategy;
import org.eclipse.orion.server.core.tasks.TaskJob;
import org.eclipse.orion.server.git.BaseToCloneConverter;
import org.eclipse.orion.server.git.jobs.ListTagsJob;
import org.eclipse.orion.server.git.objects.Tag;
import org.eclipse.orion.server.git.servlets.AbstractGitHandler;
import org.eclipse.orion.server.servlets.JsonURIUnqualificationStrategy;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;

public class GitTagHandlerV1
extends AbstractGitHandler {
    private static int PAGE_SIZE = 50;

    GitTagHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        super(statusHandler);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean handleGet(AbstractGitHandler.RequestInfo requestInfo) throws ServletException {
        String gitSegment = requestInfo.gitSegment;
        HttpServletRequest request = requestInfo.request;
        HttpServletResponse response = requestInfo.response;
        Repository db = requestInfo.db;
        IPath filePath = requestInfo.filePath;
        try {
            ListTagsJob job;
            if (gitSegment != null) {
                String tagName = gitSegment;
                URI cloneLocation = BaseToCloneConverter.getCloneLocation(GitTagHandlerV1.getURI((HttpServletRequest)request), BaseToCloneConverter.TAG);
                Ref ref = db.getRefDatabase().getRef("refs/tags/" + tagName);
                if (ref != null) {
                    Tag tag = new Tag(cloneLocation, db, ref);
                    OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)tag.toJSON(), (IURIUnqualificationStrategy)JsonURIUnqualificationStrategy.ALL_NO_GIT);
                    return true;
                }
                String msg = NLS.bind((String)"Tag not found: {0}", (Object)tagName);
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, msg, null));
            }
            String commits = request.getParameter("commits");
            int commitsNumber = commits == null ? 0 : Integer.parseInt(commits);
            String nameFilter = request.getParameter("filter");
            String page = request.getParameter("page");
            if (page == null) {
                job = new ListTagsJob(TaskJobHandler.getUserId((HttpServletRequest)request), filePath, BaseToCloneConverter.getCloneLocation(GitTagHandlerV1.getURI((HttpServletRequest)request), BaseToCloneConverter.TAG_LIST), commitsNumber, nameFilter);
                return TaskJobHandler.handleTaskJob((HttpServletRequest)request, (HttpServletResponse)response, (TaskJob)job, (ServletResourceHandler)this.statusHandler, (IURIUnqualificationStrategy)JsonURIUnqualificationStrategy.ALL_NO_GIT);
            }
            int pageNo = Integer.parseInt(page);
            int pageSize = request.getParameter("pageSize") == null ? PAGE_SIZE : Integer.parseInt(request.getParameter("pageSize"));
            job = new ListTagsJob(TaskJobHandler.getUserId((HttpServletRequest)request), filePath, BaseToCloneConverter.getCloneLocation(GitTagHandlerV1.getURI((HttpServletRequest)request), BaseToCloneConverter.TAG_LIST), commitsNumber, pageNo, pageSize, request.getRequestURI(), nameFilter);
            return TaskJobHandler.handleTaskJob((HttpServletRequest)request, (HttpServletResponse)response, (TaskJob)job, (ServletResourceHandler)this.statusHandler, (IURIUnqualificationStrategy)JsonURIUnqualificationStrategy.ALL_NO_GIT);
        }
        catch (Exception e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An error occured when looking for a tag.", (Throwable)e));
        }
    }

    @Override
    protected boolean handlePost(AbstractGitHandler.RequestInfo requestInfo) throws ServletException {
        HttpServletRequest request = requestInfo.request;
        HttpServletResponse response = requestInfo.response;
        Repository db = requestInfo.db;
        Git git = requestInfo.git;
        JSONObject toPut = requestInfo.getJSONRequest();
        RevWalk walk = new RevWalk(db);
        try {
            String tagName = toPut.getString("Name");
            String commitId = toPut.getString("Commit");
            ObjectId objectId = db.resolve(commitId);
            RevCommit revCommit = walk.lookupCommit((AnyObjectId)objectId);
            Ref ref = GitTagHandlerV1.tag(git, revCommit, tagName);
            URI cloneLocation = BaseToCloneConverter.getCloneLocation(GitTagHandlerV1.getURI((HttpServletRequest)request), BaseToCloneConverter.TAG_LIST);
            Tag tag = new Tag(cloneLocation, db, ref);
            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)tag.toJSON(), (IURIUnqualificationStrategy)JsonURIUnqualificationStrategy.ALL_NO_GIT);
            return true;
        }
        catch (Exception e) {
            boolean bl = this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An error occurred when tagging.", (Throwable)e));
            return bl;
        }
        finally {
            walk.dispose();
        }
    }

    static Ref tag(Git git, RevCommit revCommit, String tagName) throws GitAPIException {
        TagCommand tag = git.tag();
        return tag.setObjectId((RevObject)revCommit).setName(tagName).call();
    }

    @Override
    protected boolean handleDelete(AbstractGitHandler.RequestInfo requestInfo) throws ServletException {
        String gitSegment = requestInfo.gitSegment;
        HttpServletRequest request = requestInfo.request;
        HttpServletResponse response = requestInfo.response;
        Git git = requestInfo.git;
        if (gitSegment != null) {
            try {
                git.tagDelete().setTags(new String[]{gitSegment}).call();
                return true;
            }
            catch (GitAPIException e) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An error occured when removing a tag.", (Throwable)e));
            }
        }
        return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Tag deletion aborted: no tag name provided.", null));
    }
}

