/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.Connection;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;

public class LsRemoteCommand
extends TransportCommand<LsRemoteCommand, Collection<Ref>> {
    private String remote = "origin";
    private boolean heads;
    private boolean tags;
    private String uploadPack;

    public LsRemoteCommand(Repository repo) {
        super(repo);
    }

    public LsRemoteCommand setRemote(String remote) {
        this.checkCallable();
        this.remote = remote;
        return this;
    }

    public LsRemoteCommand setHeads(boolean heads) {
        this.heads = heads;
        return this;
    }

    public LsRemoteCommand setTags(boolean tags) {
        this.tags = tags;
        return this;
    }

    public LsRemoteCommand setUploadPack(String uploadPack) {
        this.uploadPack = uploadPack;
        return this;
    }

    @Override
    public Collection<Ref> call() throws GitAPIException, InvalidRemoteException, TransportException {
        return this.execute().values();
    }

    public Map<String, Ref> callAsMap() throws GitAPIException, InvalidRemoteException, TransportException {
        return Collections.unmodifiableMap(this.execute());
    }

    private Map<String, Ref> execute() throws GitAPIException, InvalidRemoteException, TransportException {
        this.checkCallable();
        Transport transport = null;
        Connection fc = null;
        try {
            transport = this.repo != null ? Transport.open(this.repo, this.remote) : Transport.open(new URIish(this.remote));
            transport.setOptionUploadPack(this.uploadPack);
            this.configure(transport);
            ArrayList<RefSpec> refSpecs = new ArrayList<RefSpec>(1);
            if (this.tags) {
                refSpecs.add(new RefSpec("refs/tags/*:refs/remotes/origin/tags/*"));
            }
            if (this.heads) {
                refSpecs.add(new RefSpec("refs/heads/*:refs/remotes/origin/*"));
            }
            HashMap<String, Ref> refmap = new HashMap<String, Ref>();
            fc = transport.openFetch();
            Collection<Ref> refs = fc.getRefs();
            if (refSpecs.isEmpty()) {
                for (Ref r : refs) {
                    refmap.put(r.getName(), r);
                }
            } else {
                block8: for (Ref r : refs) {
                    for (RefSpec rs : refSpecs) {
                        if (!rs.matchSource(r)) continue;
                        refmap.put(r.getName(), r);
                        continue block8;
                    }
                }
            }
            HashMap<String, Ref> hashMap = refmap;
            return hashMap;
        }
        catch (URISyntaxException e) {
            throw new InvalidRemoteException(MessageFormat.format(JGitText.get().invalidRemote, this.remote));
        }
        catch (NotSupportedException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfLsRemoteCommand, e);
        }
        catch (org.eclipse.jgit.errors.TransportException e) {
            throw new TransportException(e.getMessage(), e);
        }
        finally {
            if (fc != null) {
                fc.close();
            }
            if (transport != null) {
                transport.close();
            }
        }
    }
}

