/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.authentication.oauth;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthAccessTokenResponse;
import org.apache.oltu.oauth2.common.OAuthProviderType;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.eclipse.orion.server.authentication.oauth.OAuthConsumer;
import org.eclipse.orion.server.authentication.oauth.OAuthException;
import org.eclipse.orion.server.authentication.oauth.OAuthHelper;

public abstract class OAuthParams {
    protected static final String CLIENT_KEY = "client_key";
    protected static final String CLIENT_SECRET = "client_secret";
    protected static final String REDIRECT = "redirect";
    protected static final String REDIRECT_URI_LOGIN = "/login/oauth";
    protected static final String REDIRECT_URI_LINK = "/mixlogin/manageoauth/oauth";
    protected final boolean login;
    private final URL currentURL;
    private final String state;
    private final String redirect;

    public abstract OAuthProviderType getProviderType();

    public abstract String getClientKey() throws OAuthException;

    public abstract String getClientSecret() throws OAuthException;

    public abstract String getResponseType();

    public abstract String getScope();

    public abstract GrantType getGrantType();

    public abstract Class<? extends OAuthAccessTokenResponse> getTokenResponseClass();

    public abstract OAuthConsumer getNewOAuthConsumer(OAuthAccessTokenResponse var1) throws OAuthException;

    public OAuthParams(HttpServletRequest req, boolean login) throws OAuthException {
        this.redirect = req.getParameter(REDIRECT);
        this.login = login;
        this.state = UUID.randomUUID().toString();
        try {
            this.currentURL = new URL(OAuthHelper.getAuthServerRequest(req).toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new OAuthException("An error occured while authenticating");
        }
    }

    public void addAdditionsParams(OAuthClientRequest.AuthenticationRequestBuilder requestBuiler) throws OAuthException {
    }

    protected URL getCurrentURL() throws OAuthException {
        try {
            return new URL(this.currentURL.getProtocol(), this.currentURL.getHost(), this.currentURL.getPort(), "");
        }
        catch (MalformedURLException malformedURLException) {
            throw new OAuthException("An error occured while authenticating");
        }
    }

    public String getRedirectURI() throws OAuthException {
        return String.valueOf(this.getCurrentURL().toString()) + (this.login ? REDIRECT_URI_LOGIN : REDIRECT_URI_LINK);
    }

    protected String getRedirect() {
        return this.redirect;
    }

    public String getState() {
        return this.state;
    }
}

