/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.events;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.orion.internal.server.events.ReconnectMQTTClientJob;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.core.events.IEventService;
import org.eclipse.orion.server.core.events.IMessageListener;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventService
implements IEventService {
    private MqttClient mqttClient;
    private MqttConnectOptions mqttConnectOptions;
    Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
    private static AtomicBoolean reconnectionLock = new AtomicBoolean(false);
    private volatile Map<String, Set<IMessageListener>> messageListeners = new HashMap<String, Set<IMessageListener>>();
    private Callback callback;
    private static final int QOS = 1;

    public EventService() {
        this.initClient();
    }

    public boolean clientConnected() {
        return this.mqttClient.isConnected();
    }

    private void connectMQTTClient() throws MqttException {
        this.mqttClient.connect(this.mqttConnectOptions);
        this.logger.info("MQTT client connected.");
    }

    public void destroy() {
        try {
            this.mqttClient.disconnect();
        }
        catch (MqttException e) {
            this.logger.warn("Failure while disconecting the mqtt client", (Throwable)e);
        }
    }

    private void initClient() {
        String trustStore;
        String keyStore;
        String keyPassword;
        String password;
        String username;
        this.mqttConnectOptions = new MqttConnectOptions();
        String serverURI = PreferenceHelper.getString((String)"orion.events.uri", null);
        String clientId = PreferenceHelper.getString((String)"orion.events.clientId", (String)MqttClient.generateClientId());
        if (serverURI == null) {
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Using MQTT message broker at " + serverURI);
        }
        if ((username = PreferenceHelper.getString((String)"orion.events.username", null)) != null) {
            this.mqttConnectOptions.setUserName(username);
        }
        if ((password = PreferenceHelper.getString((String)"orion.events.password", null)) != null) {
            this.mqttConnectOptions.setPassword(password.toCharArray());
        }
        this.mqttConnectOptions.setCleanSession(false);
        Properties sslProperties = new Properties();
        String keyType = PreferenceHelper.getString((String)"orion.events.keyType", null);
        if (keyType != null) {
            sslProperties.put("com.ibm.ssl.keyStoreType", keyType);
            sslProperties.put("com.ibm.ssl.trustStoreType", keyType);
        }
        if ((keyPassword = PreferenceHelper.getString((String)"orion.events.keyPassword", null)) != null) {
            sslProperties.put("com.ibm.ssl.keyStorePassword", keyPassword);
            sslProperties.put("com.ibm.ssl.trustStorePassword", keyPassword);
        }
        if ((keyStore = PreferenceHelper.getString((String)"orion.events.keyStore", null)) != null) {
            sslProperties.put("com.ibm.ssl.keyStore", keyStore);
        }
        if ((trustStore = PreferenceHelper.getString((String)"orion.events.trustStore", null)) != null) {
            sslProperties.put("com.ibm.ssl.trustStore", trustStore);
        }
        this.mqttConnectOptions.setSSLProperties(sslProperties);
        try {
            this.mqttClient = new MqttClient(serverURI, clientId, (MqttClientPersistence)new MemoryPersistence());
            this.connectMQTTClient();
        }
        catch (MqttException e) {
            this.logger.warn("Connection to MQTT broker could not be established. Scheduling job to reconnect.", (Throwable)e);
            new ReconnectMQTTClientJob(this).schedule();
        }
        this.callback = new Callback();
        this.mqttClient.setCallback((MqttCallback)this.callback);
    }

    public void publish(String topic, JSONObject message) {
        try {
            this.logger.info("MQTT published event on topic: " + topic + " message:\n" + message.toString(4));
        }
        catch (JSONException e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        if (this.mqttClient == null || !this.mqttClient.isConnected()) {
            return;
        }
        MqttMessage mqttMessage = new MqttMessage(message.toString().getBytes());
        try {
            this.mqttClient.publish(topic, mqttMessage);
        }
        catch (MqttException e) {
            this.logger.warn("Failure publishing event on topic: " + topic, (Object)(", message: " + message.toString()), (Object)e);
        }
        if (this.logger.isDebugEnabled()) {
            try {
                this.logger.debug("Published event on topic: " + topic + " message:\n" + message.toString(4));
            }
            catch (JSONException e) {
                this.logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public synchronized void receive(String topic, IMessageListener messageListener) {
        Set<IMessageListener> topicListeners;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MQTT Receiving topic " + topic + " " + messageListener);
        }
        if ((topicListeners = this.messageListeners.get(topic)) == null) {
            topicListeners = new HashSet<IMessageListener>();
            this.messageListeners.put(topic, topicListeners);
        }
        if (topicListeners.isEmpty()) {
            try {
                if (this.mqttClient == null) {
                    this.logger.warn("MqttClient was unexpectedly null.");
                } else if (!this.mqttClient.isConnected()) {
                    this.logger.debug("Could not subscribe to topic " + topic + " since MqttClient is disconnected");
                } else {
                    this.mqttClient.subscribe(topic, 1);
                }
            }
            catch (MqttException e) {
                this.logger.warn("Failure subscribing on topic: " + topic, (Throwable)e);
            }
        }
        topicListeners.add(messageListener);
    }

    public void reconnectMQTTClient() {
        if (!this.mqttClient.isConnected() && reconnectionLock.compareAndSet(false, true)) {
            this.logger.warn("MQTT client was disconnected. Attempting to reconnect. " + this.toString());
            try {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        block6: {
                            try {
                                try {
                                    EventService.this.connectMQTTClient();
                                    if (EventService.this.mqttClient.isConnected()) {
                                        EventService.this.logger.info("MQTT client connection reestablished!");
                                        break block6;
                                    }
                                    EventService.this.logger.warn("Unable to reconnect MQTT client.");
                                }
                                catch (MqttException e) {
                                    EventService.this.logger.error("Could not re-connect the MQTT client. Message: " + e.getMessage() + " Reason code: " + e.getReasonCode());
                                    reconnectionLock.set(false);
                                }
                            }
                            finally {
                                reconnectionLock.set(false);
                            }
                        }
                    }
                }).start();
            }
            catch (Exception e) {
                this.logger.error("Unexpected exception occurred: " + e.getLocalizedMessage());
                reconnectionLock.set(false);
            }
        }
    }

    public void stopReceiving(String topic, IMessageListener messageListener) {
        Set<IMessageListener> topicListeners;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MQTT Stop Receiving topic " + topic + " " + messageListener);
        }
        if ((topicListeners = this.messageListeners.get(topic)) == null || !this.mqttClient.isConnected()) {
            return;
        }
        topicListeners.remove(messageListener);
        if (topicListeners.isEmpty()) {
            try {
                if (this.mqttClient != null) {
                    this.mqttClient.unsubscribe(topic);
                }
                this.messageListeners.remove(topic);
            }
            catch (MqttException e) {
                this.logger.warn("Failure unsubscribing on topic: " + topic, (Throwable)e);
            }
        }
    }

    private class Callback
    implements MqttCallback {
        private ReconnectMQTTClientJob reconnectMQTTClientJob = null;

        private Callback() {
        }

        public void connectionLost(Throwable e) {
            EventService.this.logger.warn("Connection to MQTT broker was lost. Scheduling job to reconnect.", e);
            if (this.reconnectMQTTClientJob == null) {
                this.reconnectMQTTClientJob = new ReconnectMQTTClientJob(EventService.this);
            }
            this.reconnectMQTTClientJob.schedule();
        }

        public void deliveryComplete(IMqttDeliveryToken token) {
        }

        public void messageArrived(String topic, MqttMessage msg) throws Exception {
            if (EventService.this.logger.isDebugEnabled()) {
                EventService.this.logger.debug("Message arrived " + (msg == null ? null : msg.toString()) + " topic " + topic);
            }
            JSONObject message = new JSONObject();
            message.put("Topic", (Object)topic);
            String messageText = new String(msg.getPayload());
            try {
                message.put("Message", (Object)new JSONObject(messageText));
            }
            catch (JSONException jSONException) {
                message.put("Message", (Object)messageText);
            }
            message.put("QoS", msg.getQos());
            Set topics = EventService.this.messageListeners.keySet();
            for (String registeredTopic : topics) {
                Set topicListners;
                String scrubbedTopic = registeredTopic.replaceAll("/#", ".*").replaceAll("#", ".*").replaceAll("\\\\+", ".+");
                boolean matches = false;
                try {
                    matches = Pattern.matches(scrubbedTopic, topic);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    EventService.this.logger.debug("Ignoring malformed topic:" + registeredTopic);
                }
                if (!matches) continue;
                if (EventService.this.logger.isDebugEnabled()) {
                    EventService.this.logger.debug("Pattern matched. Topic: " + topic + " . Registered topic: " + registeredTopic);
                }
                if ((topicListners = (Set)EventService.this.messageListeners.get(registeredTopic)) != null && !topicListners.isEmpty()) {
                    for (IMessageListener listner : topicListners) {
                        listner.receiveMessage(message);
                    }
                    continue;
                }
                EventService.this.logger.warn("Topic listener could not be found to topic we were subscribed to. Topic: " + registeredTopic);
            }
        }
    }
}

