/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.messaging.bridge.api.BridgeContext;
import com.sun.messaging.bridge.api.MessageTransformer;
import com.sun.messaging.bridge.api.StompFrameMessageFactory;
import com.sun.messaging.bridge.api.StompProtocolException;
import com.sun.messaging.bridge.api.StompProtocolHandler;
import com.sun.messaging.bridge.service.stomp.LoggerWrapperImpl;
import com.sun.messaging.bridge.service.stomp.StompConnectionImpl;
import com.sun.messaging.bridge.service.stomp.StompFrameMessageImpl;
import com.sun.messaging.bridge.service.stomp.StompServer;
import com.sun.messaging.bridge.service.stomp.resources.StompBridgeResources;
import com.sun.messaging.jmq.Version;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class StompProtocolHandlerImpl
extends StompProtocolHandler {
    private static final Version mqversion = new Version();
    private StompBridgeResources sbr = null;
    private StompServer server = null;

    public StompProtocolHandlerImpl(StompServer server) {
        super(LoggerWrapperImpl.wrap(server.getLogger()));
        this.server = server;
        this.sbr = server.getStompBridgeResources();
        this.stompConnection = new StompConnectionImpl(this);
    }

    BridgeContext getBridgeContext() {
        return this.server.getBridgeContext();
    }

    Properties getJMSConfig() {
        return this.server.getJMSConfig();
    }

    Logger getLogger() {
        return this.server.getLogger();
    }

    MessageTransformer getMessageTransformer() {
        return this.server.getMessageTransformer();
    }

    StompBridgeResources getStompBridgeResources() {
        StompProtocolHandlerImpl stompProtocolHandlerImpl = this;
        return stompProtocolHandlerImpl.server.getStompBridgeResources();
    }

    @Override
    public String getSupportedVersions() {
        return "1.0,1.2";
    }

    @Override
    public String getServerName() {
        return mqversion.getProductName();
    }

    @Override
    public String negotiateVersion(String acceptVersions) throws StompProtocolException {
        if (acceptVersions == null) {
            return "1.0";
        }
        StringTokenizer st = new StringTokenizer(acceptVersions, ",");
        String ver = null;
        while (st.hasMoreElements()) {
            ver = st.nextToken();
            if (Version.compareVersions(ver, "1.2") == 0) {
                return "1.2";
            }
            if (Version.compareVersions(ver, "1.0") != 0) continue;
            return "1.0";
        }
        throw new StompProtocolException(this.sbr.getKString("BSS4040", acceptVersions));
    }

    @Override
    public StompFrameMessageFactory getStompFrameMessageFactory() {
        return StompFrameMessageImpl.getFactory();
    }

    @Override
    public String getTemporaryQueuePrefix() {
        return "temporary_destination://queue/";
    }

    @Override
    public String getTemporaryTopicPrefix() {
        return "temporary_destination://topic/";
    }

    @Override
    protected String getKStringI_CLOSE_STOMP_CONN(String stompconn) {
        return this.sbr.getKString("BSS1008", stompconn);
    }

    @Override
    protected String getKStringW_CLOSE_STOMP_CONN_FAILED(String stompconn, String emsg) {
        return this.sbr.getKString("BSS2003", stompconn, emsg);
    }

    @Override
    protected String getKStringE_COMMAND_FAILED(String cmd, String emsg, String stompconn) {
        Object[] eparam = new String[]{cmd, emsg, stompconn};
        return this.sbr.getKString("BSS3002", eparam);
    }

    @Override
    protected String getKStringE_UNABLE_SEND_ERROR_MSG(String emsg, String eemsg) {
        return this.sbr.getKString("BSS3001", emsg, eemsg);
    }

    @Override
    protected String getKStringX_SUBID_ALREADY_EXISTS(String subid) {
        return this.sbr.getKString("BSS4018", subid);
    }

    @Override
    protected String getKStringX_UNSUBSCRIBE_WITHOUT_HEADER(String destHeader, String subidHeader) {
        return this.sbr.getKString("BSS4019", destHeader, subidHeader);
    }

    @Override
    protected String getKStringX_HEADER_NOT_SPECIFIED_FOR(String header, String cmd) {
        return this.sbr.getKString("BSS4020", header, cmd);
    }

    @Override
    protected String getKStringX_SUBSCRIBER_ID_NOT_FOUND(String subid) {
        return this.sbr.getKString("BSS4007", subid);
    }

    @Override
    protected String getKStringW_NO_SUBID_TXNACK(String subidHeader, String tid, String subidPrefix, String msgid) {
        Object[] eparam = new String[]{subidHeader, tid, subidPrefix, msgid};
        return this.sbr.getKString("BSS2005", eparam);
    }

    @Override
    protected String getKStringW_NO_SUBID_NONTXNACK(String subidHeader, String subidPrefix, String msgid) {
        Object[] eparam = new String[]{subidHeader, subidPrefix, msgid};
        return this.sbr.getKString("BSS2006", eparam);
    }

    @Override
    protected String getKStringX_INVALID_MESSAGE_PROP_NAME(String name) {
        return this.sbr.getKString("BSS4039", name);
    }

    @Override
    protected String getKStringX_INVALID_HEADER_VALUE(String header, String value) {
        return this.sbr.getKString("BSS4012", header, value);
    }

    @Override
    protected String getKStringI_USE_HEADER_IGNORE_OBSOLETE_HEADER_FOR(String useHeader, String ignoreHeaders, String cmd) {
        Object[] args = new String[]{useHeader, ignoreHeaders, cmd};
        return this.sbr.getKString("BSS1025", args);
    }
}

