/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.qpack.internal.instruction;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.compression.NBitIntegerEncoder;
import org.eclipse.jetty.http.compression.NBitStringEncoder;
import org.eclipse.jetty.http3.qpack.Instruction;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;

public class IndexedNameEntryInstruction
implements Instruction {
    private final boolean _dynamic;
    private final int _index;
    private final boolean _huffman;
    private final String _value;

    public IndexedNameEntryInstruction(boolean dynamic, int index, boolean huffman, String value) {
        this._dynamic = dynamic;
        this._index = index;
        this._huffman = huffman;
        this._value = value;
    }

    public boolean isDynamic() {
        return this._dynamic;
    }

    public int getIndex() {
        return this._index;
    }

    public String getValue() {
        return this._value;
    }

    @Override
    public void encode(ByteBufferPool.Lease lease) {
        int size = NBitIntegerEncoder.octetsNeeded((int)6, (long)this._index) + NBitStringEncoder.octetsNeeded((int)8, (String)this._value, (boolean)this._huffman);
        ByteBuffer buffer = lease.acquire(size, false);
        buffer.put((byte)(0x80 | (this._dynamic ? 0 : 64)));
        NBitIntegerEncoder.encode((ByteBuffer)buffer, (int)6, (long)this._index);
        NBitStringEncoder.encode((ByteBuffer)buffer, (int)8, (String)this._value, (boolean)this._huffman);
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
        lease.append(buffer, true);
    }

    public String toString() {
        return String.format("%s@%x[index=%d,name=%s]", this.getClass().getSimpleName(), this.hashCode(), this.getIndex(), this.getValue());
    }
}

