/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.demos;

import java.io.IOException;
import java.nio.file.Path;
import org.eclipse.jetty.demos.ExampleUtil;
import org.eclipse.jetty.demos.JettyDemos;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.webapp.Configurations;
import org.eclipse.jetty.webapp.WebAppContext;

public class OneWebApp {
    public static Server createServer(int port) throws IOException {
        Server server = new Server(port);
        WebAppContext webapp = new WebAppContext();
        webapp.setContextPath("/");
        Path warFile = JettyDemos.find("demo-async-rest/demo-async-rest-webapp/target/demo-async-rest-webapp-@VER@.war");
        webapp.setWar(warFile.toString());
        server.setHandler((Handler)webapp);
        return server;
    }

    public static void main(String[] args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        Server server = OneWebApp.createServer(port);
        Configurations.setServerDefault((Server)server);
        server.start();
        server.dumpStdErr();
        server.join();
    }
}

