/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.demos;

import org.eclipse.jetty.demos.AsyncEchoServlet;
import org.eclipse.jetty.demos.ExampleUtil;
import org.eclipse.jetty.demos.HelloServlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.ServletContextHandler;

public class ExampleServer {
    public static Server createServer(int port) {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(port);
        server.setConnectors(new Connector[]{connector});
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        context.addServlet(HelloServlet.class, "/hello");
        context.addServlet(AsyncEchoServlet.class, "/echo/*");
        server.setHandler((Handler)new HandlerList(new Handler[]{context, new DefaultHandler()}));
        return server;
    }

    public static void main(String[] args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        Server server = ExampleServer.createServer(port);
        server.start();
        server.join();
    }
}

