/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.unixdomain.server;

import java.io.Closeable;
import java.io.IOException;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.channels.Channel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.io.SocketChannelEndPoint;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.JavaVersion;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.thread.Scheduler;

@ManagedObject
public class UnixDomainServerConnector
extends AbstractConnector {
    public static final int MAX_UNIX_DOMAIN_PATH_LENGTH = 107;
    private final AtomicReference<Closeable> acceptor;
    private final SelectorManager selectorManager;
    private ServerSocketChannel serverChannel;
    private Path unixDomainPath;
    private boolean inheritChannel;
    private int acceptQueueSize;
    private int acceptedReceiveBufferSize;
    private int acceptedSendBufferSize;

    public UnixDomainServerConnector(Server server, ConnectionFactory ... factories) {
        this(server, null, null, null, -1, -1, factories);
    }

    public UnixDomainServerConnector(Server server, int acceptors, int selectors, ConnectionFactory ... factories) {
        this(server, null, null, null, acceptors, selectors, factories);
    }

    public UnixDomainServerConnector(Server server, Executor executor, Scheduler scheduler, ByteBufferPool pool, int acceptors, int selectors, ConnectionFactory ... factories) {
        ConnectionFactory[] connectionFactoryArray;
        if (factories.length > 0) {
            connectionFactoryArray = factories;
        } else {
            ConnectionFactory[] connectionFactoryArray2 = new ConnectionFactory[1];
            connectionFactoryArray = connectionFactoryArray2;
            connectionFactoryArray2[0] = new HttpConnectionFactory();
        }
        super(server, executor, scheduler, pool, acceptors, connectionFactoryArray);
        this.acceptor = new AtomicReference();
        this.selectorManager = this.newSelectorManager(this.getExecutor(), this.getScheduler(), selectors);
        this.addBean(this.selectorManager, true);
    }

    protected SelectorManager newSelectorManager(Executor executor, Scheduler scheduler, int selectors) {
        return new UnixDomainSelectorManager(executor, scheduler, selectors);
    }

    @ManagedAttribute(value="The Unix-Domain path this connector listens to")
    public Path getUnixDomainPath() {
        return this.unixDomainPath;
    }

    public void setUnixDomainPath(Path unixDomainPath) {
        this.unixDomainPath = unixDomainPath;
    }

    @ManagedAttribute(value="Whether this connector uses a server channel inherited from the JVM")
    public boolean isInheritChannel() {
        return this.inheritChannel;
    }

    public void setInheritChannel(boolean inheritChannel) {
        this.inheritChannel = inheritChannel;
    }

    @ManagedAttribute(value="The accept queue size (backlog) for the server socket")
    public int getAcceptQueueSize() {
        return this.acceptQueueSize;
    }

    public void setAcceptQueueSize(int acceptQueueSize) {
        this.acceptQueueSize = acceptQueueSize;
    }

    @ManagedAttribute(value="The SO_RCVBUF option for accepted sockets")
    public int getAcceptedReceiveBufferSize() {
        return this.acceptedReceiveBufferSize;
    }

    public void setAcceptedReceiveBufferSize(int acceptedReceiveBufferSize) {
        this.acceptedReceiveBufferSize = acceptedReceiveBufferSize;
    }

    @ManagedAttribute(value="The SO_SNDBUF option for accepted sockets")
    public int getAcceptedSendBufferSize() {
        return this.acceptedSendBufferSize;
    }

    public void setAcceptedSendBufferSize(int acceptedSendBufferSize) {
        this.acceptedSendBufferSize = acceptedSendBufferSize;
    }

    protected void doStart() throws Exception {
        this.getBeans(SelectorManager.SelectorManagerListener.class).forEach(arg_0 -> ((SelectorManager)this.selectorManager).addEventListener(arg_0));
        this.serverChannel = this.open();
        this.addBean(this.serverChannel);
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.removeBean(this.serverChannel);
        this.close();
        this.getBeans(SelectorManager.SelectorManagerListener.class).forEach(arg_0 -> ((SelectorManager)this.selectorManager).removeEventListener(arg_0));
    }

    protected void accept(int acceptorID) throws IOException {
        ServerSocketChannel serverChannel = this.serverChannel;
        if (serverChannel != null) {
            SocketChannel channel = serverChannel.accept();
            this.accepted(channel);
        }
    }

    private void accepted(SocketChannel channel) throws IOException {
        channel.configureBlocking(false);
        this.configure(channel);
        this.selectorManager.accept((SelectableChannel)channel);
    }

    protected void configure(SocketChannel channel) throws IOException {
        int sndBufSize;
        int rcvBufSize = this.getAcceptedReceiveBufferSize();
        if (rcvBufSize > 0) {
            channel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)rcvBufSize);
        }
        if ((sndBufSize = this.getAcceptedSendBufferSize()) > 0) {
            channel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)sndBufSize);
        }
    }

    public Object getTransport() {
        return this.serverChannel;
    }

    private ServerSocketChannel open() throws IOException {
        ServerSocketChannel serverChannel = this.openServerSocketChannel();
        if (this.getAcceptors() == 0) {
            serverChannel.configureBlocking(false);
            this.acceptor.set(this.selectorManager.acceptor((SelectableChannel)serverChannel));
        }
        return serverChannel;
    }

    private void close() throws IOException {
        ServerSocketChannel serverChannel = this.serverChannel;
        this.serverChannel = null;
        IO.close((Closeable)serverChannel);
        Files.deleteIfExists(this.getUnixDomainPath());
    }

    private ServerSocketChannel openServerSocketChannel() throws IOException {
        ServerSocketChannel serverChannel = null;
        if (this.isInheritChannel()) {
            Channel channel = System.inheritedChannel();
            if (channel instanceof ServerSocketChannel) {
                serverChannel = (ServerSocketChannel)channel;
            } else {
                LOG.warn("Unable to use System.inheritedChannel() {}. Trying a new Unix-Domain ServerSocketChannel at {}", (Object)channel, (Object)this.getUnixDomainPath());
            }
        }
        if (serverChannel == null) {
            serverChannel = this.bindServerSocketChannel();
        }
        return serverChannel;
    }

    private ServerSocketChannel bindServerSocketChannel() throws IOException {
        SocketAddress socketAddress;
        ServerSocketChannel serverChannel;
        Path unixDomainPath = this.getUnixDomainPath();
        try {
            ProtocolFamily family = Enum.valueOf(StandardProtocolFamily.class, "UNIX");
            Class<?> channelClass = Class.forName("java.nio.channels.ServerSocketChannel");
            serverChannel = (ServerSocketChannel)channelClass.getMethod("open", ProtocolFamily.class).invoke(null, family);
            Class<?> addressClass = Class.forName("java.net.UnixDomainSocketAddress");
            socketAddress = (SocketAddress)addressClass.getMethod("of", Path.class).invoke(null, unixDomainPath);
        }
        catch (Throwable x) {
            String message = "Unix-Domain SocketChannels are available starting from Java 16, your Java version is: " + JavaVersion.VERSION;
            throw new UnsupportedOperationException(message, x);
        }
        try {
            serverChannel.bind(socketAddress, this.getAcceptQueueSize());
            return serverChannel;
        }
        catch (IOException x) {
            String message = String.format("Could not bind %s to %s", UnixDomainServerConnector.class.getSimpleName(), unixDomainPath);
            throw new IOException(message, x);
        }
    }

    public void setAccepting(boolean accepting) {
        super.setAccepting(accepting);
        if (this.getAcceptors() == 0) {
            return;
        }
        if (accepting) {
            Closeable acceptor;
            if (this.acceptor.get() == null && !this.acceptor.compareAndSet(null, acceptor = this.selectorManager.acceptor((SelectableChannel)this.serverChannel))) {
                IO.close((Closeable)acceptor);
            }
        } else {
            Closeable acceptor = this.acceptor.get();
            if (acceptor != null && this.acceptor.compareAndSet(acceptor, null)) {
                IO.close((Closeable)acceptor);
            }
        }
    }

    public String toString() {
        return String.format("%s@%h[%s]", ((Object)((Object)this)).getClass().getSimpleName(), ((Object)((Object)this)).hashCode(), this.getUnixDomainPath());
    }

    protected class UnixDomainSelectorManager
    extends SelectorManager {
        public UnixDomainSelectorManager(Executor executor, Scheduler scheduler, int selectors) {
            super(executor, scheduler, selectors);
        }

        protected void accepted(SelectableChannel channel) throws IOException {
            UnixDomainServerConnector.this.accepted((SocketChannel)channel);
        }

        protected EndPoint newEndPoint(SelectableChannel channel, ManagedSelector selector, SelectionKey selectionKey) {
            SocketChannelEndPoint endPoint = new SocketChannelEndPoint((SocketChannel)channel, selector, selectionKey, this.getScheduler());
            endPoint.setIdleTimeout(UnixDomainServerConnector.this.getIdleTimeout());
            return endPoint;
        }

        public Connection newConnection(SelectableChannel channel, EndPoint endpoint, Object attachment) {
            return UnixDomainServerConnector.this.getDefaultConnectionFactory().newConnection((Connector)UnixDomainServerConnector.this, endpoint);
        }

        protected void endPointOpened(EndPoint endpoint) {
            super.endPointOpened(endpoint);
            UnixDomainServerConnector.this.onEndPointOpened(endpoint);
        }

        protected void endPointClosed(EndPoint endpoint) {
            UnixDomainServerConnector.this.onEndPointClosed(endpoint);
            super.endPointClosed(endpoint);
        }
    }
}

