/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.client.http.internal;

import java.nio.channels.ClosedChannelException;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicMarkableReference;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.http3.api.Session;
import org.eclipse.jetty.http3.client.http.internal.HttpConnectionOverHTTP3;
import org.eclipse.jetty.http3.client.internal.HTTP3SessionClient;
import org.eclipse.jetty.http3.frames.SettingsFrame;
import org.eclipse.jetty.http3.internal.HTTP3Session;
import org.eclipse.jetty.util.Promise;

public class SessionClientListener
implements Session.Client.Listener {
    private final AtomicMarkableReference<HttpConnectionOverHTTP3> connection = new AtomicMarkableReference<Object>(null, false);
    private final Map<String, Object> context;

    public SessionClientListener(Map<String, Object> context) {
        this.context = context;
    }

    public void onConnect(Session.Client session, Throwable failure) {
        if (failure != null) {
            this.failConnectionPromise(failure);
        }
    }

    public void onSettings(Session session, SettingsFrame frame) {
        HttpDestination destination = (HttpDestination)this.context.get("org.eclipse.jetty.client.destination");
        HttpConnectionOverHTTP3 connection = this.newHttpConnection(destination, (HTTP3SessionClient)session);
        if (this.connection.compareAndSet(null, connection, false, true)) {
            this.httpConnectionPromise().succeeded((Object)connection);
        }
    }

    public boolean onIdleTimeout(Session session) {
        long idleTimeout = ((HTTP3Session)session).getIdleTimeout();
        TimeoutException timeout = new TimeoutException("idle timeout expired: " + idleTimeout + " ms");
        if (this.failConnectionPromise(timeout)) {
            return true;
        }
        HttpConnectionOverHTTP3 connection = this.connection.getReference();
        if (connection != null) {
            return connection.onIdleTimeout(idleTimeout, timeout);
        }
        return true;
    }

    public void onDisconnect(Session session, long error, String reason) {
        this.onFailure(session, error, reason, new ClosedChannelException());
    }

    public void onFailure(Session session, long error, String reason, Throwable failure) {
        if (this.failConnectionPromise(failure)) {
            return;
        }
        HttpConnectionOverHTTP3 connection = this.connection.getReference();
        if (connection != null) {
            connection.close(failure);
        }
    }

    protected HttpConnectionOverHTTP3 newHttpConnection(HttpDestination destination, HTTP3SessionClient session) {
        return new HttpConnectionOverHTTP3(destination, session);
    }

    private Promise<Connection> httpConnectionPromise() {
        return (Promise)this.context.get("org.eclipse.jetty.client.connection.promise");
    }

    private boolean failConnectionPromise(Throwable failure) {
        boolean result = this.connection.compareAndSet(null, null, false, true);
        if (result) {
            this.httpConnectionPromise().failed(failure);
        }
        return result;
    }
}

