/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.docs.programming.server.session;

import java.io.File;
import java.net.InetSocketAddress;
import org.eclipse.jetty.memcached.session.MemcachedSessionDataMapFactory;
import org.eclipse.jetty.nosql.mongodb.MongoSessionDataStoreFactory;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.session.CachingSessionDataStoreFactory;
import org.eclipse.jetty.server.session.DatabaseAdaptor;
import org.eclipse.jetty.server.session.DefaultSessionCache;
import org.eclipse.jetty.server.session.DefaultSessionCacheFactory;
import org.eclipse.jetty.server.session.DefaultSessionIdManager;
import org.eclipse.jetty.server.session.FileSessionDataStore;
import org.eclipse.jetty.server.session.FileSessionDataStoreFactory;
import org.eclipse.jetty.server.session.HouseKeeper;
import org.eclipse.jetty.server.session.NullSessionCache;
import org.eclipse.jetty.server.session.NullSessionCacheFactory;
import org.eclipse.jetty.server.session.NullSessionDataStore;
import org.eclipse.jetty.server.session.SessionCache;
import org.eclipse.jetty.server.session.SessionDataMapFactory;
import org.eclipse.jetty.server.session.SessionDataStore;
import org.eclipse.jetty.server.session.SessionDataStoreFactory;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.webapp.WebAppContext;

public class SessionDocs {
    public void minimumDefaultSessionIdManager() {
        Server server = new Server();
        DefaultSessionIdManager idMgr = new DefaultSessionIdManager(server);
        idMgr.setWorkerName("server3");
        server.setSessionIdManager((SessionIdManager)idMgr);
    }

    public void defaultSessionIdManagerWithHouseKeeper() {
        try {
            Server server = new Server();
            DefaultSessionIdManager idMgr = new DefaultSessionIdManager(server);
            idMgr.setWorkerName("server7");
            server.setSessionIdManager((SessionIdManager)idMgr);
            HouseKeeper houseKeeper = new HouseKeeper();
            houseKeeper.setSessionIdManager((SessionIdManager)idMgr);
            houseKeeper.setIntervalSec(600L);
            idMgr.setSessionHouseKeeper(houseKeeper);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void servletContextWithSessionHandler() {
        Server server = new Server();
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)server, "/foo", 1);
        SessionHandler sessions = context.getSessionHandler();
        sessions.setMaxInactiveInterval(300);
        sessions.setUsingCookies(false);
        server.setHandler((Handler)context);
    }

    public void webAppWithSessionHandler() {
        Server server = new Server();
        WebAppContext context = new WebAppContext();
        SessionHandler sessions = context.getSessionHandler();
        sessions.setMaxInactiveInterval(300);
        sessions.setUsingCookies(false);
        server.setHandler((Handler)context);
    }

    public void defaultSessionCache() {
        Server server = new Server();
        DefaultSessionCacheFactory cacheFactory = new DefaultSessionCacheFactory();
        cacheFactory.setEvictionPolicy(60);
        cacheFactory.setSaveOnInactiveEvict(true);
        cacheFactory.setFlushOnResponseCommit(true);
        cacheFactory.setInvalidateOnShutdown(false);
        cacheFactory.setRemoveUnloadableSessions(true);
        cacheFactory.setSaveOnCreate(true);
        server.addBean((Object)cacheFactory);
    }

    public void nullSessionCache() {
        Server server = new Server();
        NullSessionCacheFactory cacheFactory = new NullSessionCacheFactory();
        cacheFactory.setFlushOnResponseCommit(true);
        cacheFactory.setRemoveUnloadableSessions(true);
        cacheFactory.setSaveOnCreate(true);
        server.addBean((Object)cacheFactory);
    }

    public void mixedSessionCache() {
        Server server = new Server();
        DefaultSessionCacheFactory cacheFactory = new DefaultSessionCacheFactory();
        cacheFactory.setEvictionPolicy(-1);
        cacheFactory.setFlushOnResponseCommit(true);
        cacheFactory.setInvalidateOnShutdown(false);
        cacheFactory.setRemoveUnloadableSessions(true);
        cacheFactory.setSaveOnCreate(true);
        server.addBean((Object)cacheFactory);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        server.setHandler((Handler)contexts);
        WebAppContext app1 = new WebAppContext();
        app1.setContextPath("/app1");
        contexts.addHandler((Handler)app1);
        WebAppContext app2 = new WebAppContext();
        app2.setContextPath("/app2");
        NullSessionCache nullSessionCache = new NullSessionCache(app2.getSessionHandler());
        nullSessionCache.setFlushOnResponseCommit(true);
        nullSessionCache.setRemoveUnloadableSessions(true);
        nullSessionCache.setSaveOnCreate(true);
        nullSessionCache.setSessionDataStore((SessionDataStore)new NullSessionDataStore());
        app2.getSessionHandler().setSessionCache((SessionCache)nullSessionCache);
    }

    public void fileSessionDataStoreFactory() {
        Server server = new Server();
        DefaultSessionCacheFactory cacheFactory = new DefaultSessionCacheFactory();
        cacheFactory.setEvictionPolicy(-1);
        cacheFactory.setFlushOnResponseCommit(true);
        cacheFactory.setInvalidateOnShutdown(false);
        cacheFactory.setRemoveUnloadableSessions(true);
        cacheFactory.setSaveOnCreate(true);
        server.addBean((Object)cacheFactory);
        FileSessionDataStoreFactory storeFactory = new FileSessionDataStoreFactory();
        storeFactory.setStoreDir(new File("/tmp/sessions"));
        storeFactory.setGracePeriodSec(3600);
        storeFactory.setSavePeriodSec(0);
        server.addBean((Object)storeFactory);
    }

    public void fileSessionDataStore() {
        WebAppContext app1 = new WebAppContext();
        app1.setContextPath("/app1");
        DefaultSessionCache cache = new DefaultSessionCache(app1.getSessionHandler());
        cache.setEvictionPolicy(-1);
        cache.setFlushOnResponseCommit(true);
        cache.setInvalidateOnShutdown(false);
        cache.setRemoveUnloadableSessions(true);
        cache.setSaveOnCreate(true);
        FileSessionDataStore store = new FileSessionDataStore();
        store.setStoreDir(new File("/tmp/sessions"));
        store.setGracePeriodSec(3600);
        store.setSavePeriodSec(0);
        cache.setSessionDataStore((SessionDataStore)store);
        app1.getSessionHandler().setSessionCache((SessionCache)cache);
    }

    public void cachingSessionDataStore() {
        Server server = new Server();
        MemcachedSessionDataMapFactory mapFactory = new MemcachedSessionDataMapFactory();
        mapFactory.setExpirySec(0);
        mapFactory.setHeartbeats(true);
        mapFactory.setAddresses(new InetSocketAddress[]{new InetSocketAddress("localhost", 11211)});
        mapFactory.setWeights(new int[]{100});
        FileSessionDataStoreFactory storeFactory = new FileSessionDataStoreFactory();
        storeFactory.setStoreDir(new File("/tmp/sessions"));
        storeFactory.setGracePeriodSec(3600);
        storeFactory.setSavePeriodSec(0);
        CachingSessionDataStoreFactory cachingSessionDataStoreFactory = new CachingSessionDataStoreFactory();
        cachingSessionDataStoreFactory.setSessionDataMapFactory((SessionDataMapFactory)mapFactory);
        cachingSessionDataStoreFactory.setSessionStoreFactory((SessionDataStoreFactory)storeFactory);
        server.addBean((Object)cachingSessionDataStoreFactory);
    }

    public void jdbcSessionDataStore() {
        DatabaseAdaptor datasourceAdaptor = new DatabaseAdaptor();
        datasourceAdaptor.setDatasourceName("/jdbc/myDS");
        DatabaseAdaptor driverAdaptor = new DatabaseAdaptor();
        driverAdaptor.setDriverInfo("com.mysql.jdbc.Driver", "jdbc:mysql://127.0.0.1:3306/sessions?user=sessionsadmin");
    }

    public void mongoSessionDataStore() {
        Server server = new Server();
        MongoSessionDataStoreFactory mongoSessionDataStoreFactory = new MongoSessionDataStoreFactory();
        mongoSessionDataStoreFactory.setGracePeriodSec(3600);
        mongoSessionDataStoreFactory.setSavePeriodSec(0);
        mongoSessionDataStoreFactory.setDbName("HttpSessions");
        mongoSessionDataStoreFactory.setCollectionName("JettySessions");
        mongoSessionDataStoreFactory.setConnectionString("mongodb:://localhost:27017");
        mongoSessionDataStoreFactory.setHost("localhost");
        mongoSessionDataStoreFactory.setPort(27017);
    }
}

