/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.operation;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.Policy;
import org.eclipse.swt.widgets.Display;

class AccumulatingProgressMonitor
extends ProgressMonitorWrapper {
    private final Display display;
    private static final boolean LOG_BEGIN_TASK = Boolean.getBoolean("AccumulatingProgressMonitor.logBeginTaskViolations");
    private Collector collector;
    private String currentTask = "";
    private volatile boolean taskStarted;
    private volatile Exception taskStartedStack;

    public AccumulatingProgressMonitor(IProgressMonitor monitor, Display display) {
        super(monitor);
        Assert.isNotNull((Object)display);
        this.display = display;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTask(String name, int totalWork) {
        if (this.taskStarted) {
            if (LOG_BEGIN_TASK) {
                IllegalStateException e = new IllegalStateException("beginTask should only be called once per instance. At least call done() before further invocations", this.taskStartedStack);
                Policy.getLog().log((IStatus)Status.warning((String)e.getLocalizedMessage(), (Throwable)e));
            }
            this.done();
        }
        if (LOG_BEGIN_TASK) {
            this.taskStartedStack = new IllegalStateException("beginTask(" + name + ", " + totalWork + ") was called here previously");
        }
        this.taskStarted = true;
        AccumulatingProgressMonitor accumulatingProgressMonitor = this;
        synchronized (accumulatingProgressMonitor) {
            this.collector = null;
        }
        this.display.asyncExec(() -> {
            this.currentTask = name;
            this.getWrappedProgressMonitor().beginTask(name, totalWork);
        });
    }

    private synchronized void clearCollector(Collector collectorToClear) {
        if (this.collector == collectorToClear) {
            this.collector = null;
        }
    }

    private void createCollector(String taskName, String subTask, double work) {
        this.collector = new Collector(taskName, subTask, work, this.getWrappedProgressMonitor());
        this.display.asyncExec((Runnable)this.collector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        if (!this.taskStarted) {
            return;
        }
        this.taskStarted = false;
        this.taskStartedStack = null;
        AccumulatingProgressMonitor accumulatingProgressMonitor = this;
        synchronized (accumulatingProgressMonitor) {
            this.collector = null;
        }
        this.display.asyncExec(() -> this.getWrappedProgressMonitor().done());
    }

    public synchronized void internalWorked(double work) {
        if (this.collector == null) {
            this.createCollector(null, null, work);
        } else {
            this.collector.worked(work);
        }
    }

    public synchronized void setTaskName(String name) {
        this.currentTask = name;
        if (this.collector == null) {
            this.createCollector(name, null, 0.0);
        } else {
            this.collector.setTaskName(name);
        }
    }

    public synchronized void subTask(String name) {
        if (this.collector == null) {
            this.createCollector(null, name, 0.0);
        } else {
            this.collector.subTask(name);
        }
    }

    public synchronized void worked(int work) {
        this.internalWorked(work);
    }

    public void clearBlocked() {
        IProgressMonitor pm = this.getWrappedProgressMonitor();
        if (pm == null) {
            return;
        }
        this.display.asyncExec(() -> {
            pm.clearBlocked();
            Dialog.getBlockedHandler().clearBlocked();
        });
    }

    public void setBlocked(IStatus reason) {
        IProgressMonitor pm = this.getWrappedProgressMonitor();
        if (pm == null) {
            return;
        }
        this.display.asyncExec(() -> {
            pm.setBlocked(reason);
            Dialog.getBlockedHandler().showBlocked(pm, reason, this.currentTask);
        });
    }

    private class Collector
    implements Runnable {
        private String taskName;
        private String subTask;
        private double worked;
        private final IProgressMonitor monitor;

        public Collector(String taskName, String subTask, double work, IProgressMonitor monitor) {
            this.taskName = taskName;
            this.subTask = subTask;
            this.worked = work;
            this.monitor = monitor;
        }

        public void setTaskName(String name) {
            this.taskName = name;
        }

        public void worked(double workedIncrement) {
            this.worked += workedIncrement;
        }

        public void subTask(String subTaskName) {
            this.subTask = subTaskName;
        }

        @Override
        public void run() {
            AccumulatingProgressMonitor.this.clearCollector(this);
            if (this.taskName != null) {
                this.monitor.setTaskName(this.taskName);
            }
            if (this.subTask != null) {
                this.monitor.subTask(this.subTask);
            }
            if (this.worked > 0.0) {
                this.monitor.internalWorked(this.worked);
            }
        }
    }
}

