/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.views.IViewCategory;
import org.eclipse.ui.views.IViewDescriptor;

public class ViewCategory
implements IViewCategory {
    private final String id;
    private final String label;
    private final IPath path;
    private final List<IViewDescriptor> descriptors = new ArrayList<IViewDescriptor>();

    public ViewCategory(String id, String label) {
        this.id = id;
        this.label = label;
        this.path = IPath.fromOSString((String)id);
    }

    void addDescriptor(IViewDescriptor descriptor) {
        this.descriptors.add(descriptor);
    }

    @Override
    public IViewDescriptor[] getViews() {
        Collection<IViewDescriptor> allowedViews = WorkbenchActivityHelper.restrictCollection(this.descriptors, new ArrayList());
        return allowedViews.toArray(new IViewDescriptor[allowedViews.size()]);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public IPath getPath() {
        return this.path;
    }
}

