/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.ui;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.oomph.ui.Messages;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class ErrorDialog
extends MessageDialog {
    private static final int TEXT_LINE_COUNT = 15;
    private final Throwable throwable;
    private final int detailsButtonID;
    private Text text;

    private ErrorDialog(String title, Throwable throwable) {
        this(title, throwable, 0, 1, IDialogConstants.OK_LABEL, IDialogConstants.SHOW_DETAILS_LABEL);
    }

    protected ErrorDialog(String title, Throwable throwable, int defaultButtonID, int detailsButtonID, String ... dialogButtonLabels) {
        super(null, title, null, Messages.ErrorDialog_message_internalError + StringUtil.NL + ErrorDialog.getMessage(throwable), 1, dialogButtonLabels, defaultButtonID);
        this.throwable = throwable;
        this.detailsButtonID = detailsButtonID;
        this.setShellStyle(68848);
    }

    protected void createDropDownText(Composite parent) {
        this.text = new Text(parent, 2816);
        this.text.setFont(parent.getFont());
        StringWriter stringWriter = new StringWriter();
        PrintWriter out = new PrintWriter(stringWriter);
        this.throwable.printStackTrace(out);
        out.close();
        this.text.setText(stringWriter.toString());
        GridData data = new GridData(1808);
        data.heightHint = this.text.getLineHeight() * 15;
        data.horizontalSpan = 2;
        this.text.setLayoutData((Object)data);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == this.detailsButtonID) {
            this.toggleDetailsArea();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    private void toggleDetailsArea() {
        Point windowSize = this.getShell().getSize();
        Point oldSize = this.getContents().computeSize(-1, -1);
        if (this.text != null) {
            this.text.dispose();
            this.text = null;
            this.getButton(this.detailsButtonID).setText(IDialogConstants.SHOW_DETAILS_LABEL);
        } else {
            this.createDropDownText((Composite)this.getContents());
            this.getButton(this.detailsButtonID).setText(IDialogConstants.HIDE_DETAILS_LABEL);
        }
        Point newSize = this.getContents().computeSize(-1, -1);
        this.getShell().setSize(new Point(windowSize.x, windowSize.y + newSize.y - oldSize.y));
    }

    private static String getMessage(Throwable t) {
        try {
            String message = ErrorDialog.getMessageRecursively(t);
            if (!StringUtil.isEmpty((String)message)) {
                return message;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return t.getClass().getSimpleName();
    }

    private static String getMessageRecursively(Throwable t) {
        Throwable cause;
        String message = t.getMessage();
        if (StringUtil.isEmpty((String)message) && (cause = t.getCause()) != null) {
            return ErrorDialog.getMessageRecursively(cause);
        }
        return message;
    }

    private static void openWithDetail(Throwable detail) {
        ErrorDialog dialog = new ErrorDialog(Messages.ErrorDialog_title, detail);
        dialog.open();
    }

    public static void open(final Throwable detail) {
        if (Display.getCurrent() == Display.getDefault()) {
            ErrorDialog.openWithDetail(detail);
        } else {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ErrorDialog.openWithDetail(detail);
                }
            });
        }
    }
}

