/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.ui.model.application.ui.menu.MDynamicMenuContribution;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;

class DynamicContributionContributionItem
extends ContributionItem {
    private final MDynamicMenuContribution model;
    private final IMenuListener menuListener = IContributionManager::markDirty;
    private final IContributionFactory factory;

    public DynamicContributionContributionItem(MDynamicMenuContribution item, IContributionFactory factory) {
        super(item.getElementId());
        this.model = item;
        this.factory = factory;
    }

    public boolean isDirty() {
        return true;
    }

    public boolean isDynamic() {
        return true;
    }

    public MDynamicMenuContribution getModel() {
        return this.model;
    }

    public boolean isVisible() {
        if (this.factory.isEnabled(this.model.getContributionURI())) {
            return super.isVisible();
        }
        return false;
    }

    public void setParent(IContributionManager parent) {
        IMenuManager menuMgr;
        if (this.getParent() instanceof IMenuManager) {
            menuMgr = (IMenuManager)this.getParent();
            menuMgr.removeMenuListener(this.menuListener);
        }
        if (parent instanceof IMenuManager) {
            menuMgr = (IMenuManager)parent;
            menuMgr.addMenuListener(this.menuListener);
        }
        super.setParent(parent);
    }
}

