/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.storage;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.container.ModuleWire;
import org.eclipse.osgi.container.ModuleWiring;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.osgi.internal.framework.FilterImpl;
import org.eclipse.osgi.internal.hookregistry.ClassLoaderHook;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.osgi.framework.InvalidSyntaxException;

public class NativeCodeFinder {
    public static final String REQUIREMENT_NATIVE_PATHS_ATTRIBUTE = "native.paths";
    private static final String[] EMPTY_STRINGS = new String[0];
    public static final String EXTERNAL_LIB_PREFIX = "external:";
    private final BundleInfo.Generation generation;
    private final Debug debug;
    private final Collection<String> loadedNativeCode = new ArrayList<String>(1);

    public NativeCodeFinder(BundleInfo.Generation generation) {
        this.generation = generation;
        this.debug = generation.getBundleInfo().getStorage().getConfiguration().getDebug();
    }

    public String[] mapLibraryNames(String mappedLibName) {
        int extIndex = mappedLibName.lastIndexOf(46);
        List<String> LIB_EXTENSIONS = this.generation.getBundleInfo().getStorage().getConfiguration().LIB_EXTENSIONS;
        if (LIB_EXTENSIONS.isEmpty() || extIndex < 0) {
            return EMPTY_STRINGS;
        }
        String libNameBase = mappedLibName.substring(0, extIndex);
        String[] results = new String[LIB_EXTENSIONS.size()];
        int i = 0;
        while (i < results.length) {
            results[i] = String.valueOf(libNameBase) + LIB_EXTENSIONS.get(i);
            ++i;
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String findLibrary(String libname) {
        String path = this.findLibrary0(libname);
        if (path != null) {
            Collection<String> collection = this.loadedNativeCode;
            synchronized (collection) {
                if (this.loadedNativeCode.contains(path) || this.generation.getBundleInfo().getStorage().getConfiguration().COPY_NATIVES) {
                    String temp = this.generation.getBundleInfo().getStorage().copyToTempLibrary(this.generation, path);
                    if (temp != null) {
                        path = temp;
                    }
                } else {
                    this.loadedNativeCode.add(path);
                }
            }
        }
        return path;
    }

    private String findLibrary0(String libname) {
        String[] altMappedNames;
        String path = null;
        List<ClassLoaderHook> hooks = this.generation.getBundleInfo().getStorage().getConfiguration().getHookRegistry().getClassLoaderHooks();
        for (ClassLoaderHook hook : hooks) {
            path = hook.findLocalLibrary(this.generation, libname);
            if (path == null) continue;
            return path;
        }
        String mappedName = System.mapLibraryName(libname);
        path = this.findBundleNativeCode(libname, mappedName, altMappedNames = this.mapLibraryNames(mappedName));
        return path != null ? path : this.findEclipseNativeCode(libname, mappedName, altMappedNames);
    }

    private String findEclipseNativeCode(String libname, String mappedName, String[] altMappedNames) {
        String result;
        if (libname.length() == 0) {
            return null;
        }
        if (libname.charAt(0) == '/' || libname.charAt(0) == '\\') {
            libname = libname.substring(1);
        }
        if ((result = this.searchEclipseVariants(mappedName)) != null) {
            return result;
        }
        int i = 0;
        while (i < altMappedNames.length && result == null) {
            result = this.searchEclipseVariants(altMappedNames[i]);
            ++i;
        }
        return result;
    }

    private String searchEclipseVariants(String path) {
        List<String> ECLIPSE_LIB_VARIANTS = this.generation.getBundleInfo().getStorage().getConfiguration().ECLIPSE_LIB_VARIANTS;
        for (String variant : ECLIPSE_LIB_VARIANTS) {
            BundleFile baseBundleFile = this.generation.getBundleFile();
            BundleEntry libEntry = baseBundleFile.getEntry(String.valueOf(variant) + path);
            if (libEntry == null) continue;
            File libFile = baseBundleFile.getFile(String.valueOf(variant) + path, true);
            if (libFile == null) {
                return null;
            }
            if ("hpux".equals(this.generation.getBundleInfo().getStorage().getConfiguration().getOS())) {
                try {
                    Runtime.getRuntime().exec(new String[]{"chmod", "755", libFile.getAbsolutePath()}).waitFor();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return libFile.getAbsolutePath();
        }
        return null;
    }

    private String findBundleNativeCode(String libname, String mappedName, String[] altMappedNames) {
        List<String> nativePaths;
        String path = null;
        if (this.debug.DEBUG_LOADER) {
            Debug.println("  mapped library name: " + mappedName);
        }
        if ((nativePaths = this.getNativePaths()).isEmpty()) {
            return null;
        }
        path = this.findNativePath(nativePaths, mappedName);
        if (path == null) {
            int i = 0;
            while (i < altMappedNames.length && path == null) {
                path = this.findNativePath(nativePaths, altMappedNames[i]);
                ++i;
            }
        }
        if (path == null) {
            if (this.debug.DEBUG_LOADER) {
                Debug.println("  library does not exist: " + mappedName);
            }
            path = this.findNativePath(nativePaths, libname);
        }
        if (this.debug.DEBUG_LOADER) {
            Debug.println("  returning library: " + path);
        }
        return path;
    }

    private List<String> getNativePaths() {
        List<ModuleWire> nativeCode;
        ModuleRevision revision = this.generation.getRevision();
        ModuleWiring wiring = revision.getWiring();
        if (wiring == null) {
            return Collections.emptyList();
        }
        if ((revision.getTypes() & 1) != 0) {
            List<ModuleWire> hosts = wiring.getRequiredModuleWires("osgi.wiring.host");
            if (hosts == null) {
                return Collections.emptyList();
            }
            if (!hosts.isEmpty()) {
                wiring = hosts.get(0).getProviderWiring();
            }
        }
        if ((nativeCode = wiring.getRequiredModuleWires("osgi.native")) == null || nativeCode.isEmpty()) {
            return Collections.emptyList();
        }
        for (ModuleWire moduleWire : nativeCode) {
            if (!moduleWire.getRequirement().getRevision().equals(revision)) continue;
            List result = (List)moduleWire.getRequirement().getAttributes().get(REQUIREMENT_NATIVE_PATHS_ATTRIBUTE);
            if (result != null) {
                return result;
            }
            try {
                List indexResult;
                FilterImpl filter = FilterImpl.newInstance(moduleWire.getRequirement().getDirectives().get("filter"));
                int index = -1;
                Map<String, Object> capabilityAttrs = moduleWire.getCapability().getAttributes();
                for (FilterImpl child : filter.getChildren()) {
                    ++index;
                    if (child.matches(capabilityAttrs)) break;
                }
                if (index == -1 || (indexResult = (List)moduleWire.getRequirement().getAttributes().get("native.paths." + index)) == null) continue;
                return indexResult;
            }
            catch (InvalidSyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return Collections.emptyList();
    }

    private String findNativePath(List<String> nativePaths, String libname) {
        int slash = libname.lastIndexOf(47);
        if (slash >= 0) {
            libname = libname.substring(slash + 1);
        }
        for (String nativePath : nativePaths) {
            String path;
            slash = nativePath.lastIndexOf(47);
            String string = path = slash < 0 ? nativePath : nativePath.substring(slash + 1);
            if (!path.equals(libname)) continue;
            if (nativePath.startsWith(EXTERNAL_LIB_PREFIX)) {
                String externalPath = this.generation.getBundleInfo().getStorage().getConfiguration().substituteVars(nativePath.substring(EXTERNAL_LIB_PREFIX.length()));
                File nativeFile = new File(externalPath);
                return nativeFile.getAbsolutePath();
            }
            File nativeFile = this.generation.getBundleFile().getFile(nativePath, true);
            if (nativeFile == null) continue;
            return nativeFile.getAbsolutePath();
        }
        return null;
    }
}

