/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.internal.views.markers.ExtendedMarkersView;
import org.eclipse.ui.internal.views.markers.MarkerSupportItem;
import org.eclipse.ui.internal.views.markers.Markers;

class MarkerViewerContentProvider
implements ITreeContentProvider {
    private Object input;
    private final ExtendedMarkersView markersView;

    public MarkerViewerContentProvider(ExtendedMarkersView extendedMarkersView) {
        this.markersView = extendedMarkersView;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.input = newInput;
    }

    public void dispose() {
    }

    /*
     * WARNING - void declaration
     */
    public Object[] getChildren(Object parentElement) {
        Object object = parentElement;
        if (object instanceof MarkerSupportItem) {
            void markerItem;
            MarkerSupportItem markerSupportItem = (MarkerSupportItem)object;
            MarkerSupportItem cfr_ignored_0 = (MarkerSupportItem)object;
            Object[] children = markerItem.getChildren();
            return this.getLimitedChildren(children);
        }
        return new Object[0];
    }

    public Object[] getElements(Object inputElement) {
        return this.getLimitedChildren(((Markers)this.input).getElements());
    }

    private Object[] getLimitedChildren(Object[] children) {
        boolean limitsEnabled = this.markersView.getGenerator().isMarkerLimitsEnabled();
        int limits = this.markersView.getGenerator().getMarkerLimits();
        if (!limitsEnabled || limits <= 0 || limits > children.length) {
            return children;
        }
        Object[] newChildren = new Object[limits];
        System.arraycopy(children, 0, newChildren, 0, limits);
        return newChildren;
    }

    /*
     * WARNING - void declaration
     */
    public Object getParent(Object element) {
        MarkerSupportItem parent = null;
        Object object = element;
        if (object instanceof MarkerSupportItem) {
            void markerItem;
            MarkerSupportItem markerSupportItem = (MarkerSupportItem)object;
            MarkerSupportItem cfr_ignored_0 = (MarkerSupportItem)object;
            parent = markerItem.getParent();
        }
        if (parent == null) {
            return this.input;
        }
        return parent;
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasChildren(Object element) {
        boolean bl;
        Object object = element;
        if (object instanceof MarkerSupportItem) {
            void markerItem;
            MarkerSupportItem markerSupportItem = (MarkerSupportItem)object;
            MarkerSupportItem cfr_ignored_0 = (MarkerSupportItem)object;
            bl = markerItem.getChildren().length > 0;
        } else {
            bl = false;
        }
        return bl;
    }
}

