/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.simpleconfigurator.manipulator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.Arrays;
import org.eclipse.equinox.internal.frameworkadmin.equinox.Messages;
import org.eclipse.equinox.internal.frameworkadmin.utils.Utils;
import org.eclipse.equinox.internal.simpleconfigurator.utils.BundleInfo;
import org.osgi.framework.Version;

public class SimpleConfiguratorManipulatorUtils {
    private static final String VERSION_PREFIX = "#version=";
    private static final String VERSION_1 = "1";
    private static final Version OLD_STYLE_SIMPLE_CONFIGURATOR_VERSION = new Version("1.0.100.v20081206");
    private static final Version DEFAULT_ENCODING_CONFIGURATOR_VERSION = new Version("1.0.200.v20100503");

    public static void writeConfiguration(BundleInfo[] simpleInfos, File outputFile) throws IOException {
        IOException caughtException;
        block17: {
            if (!Utils.createParentDir((File)outputFile)) {
                throw new IllegalStateException(Messages.exception_failedToCreateDir);
            }
            caughtException = null;
            FileOutputStream stream = null;
            try {
                try {
                    stream = new FileOutputStream(outputFile);
                    SimpleConfiguratorManipulatorUtils.writeConfiguration(simpleInfos, stream);
                }
                catch (IOException e) {
                    caughtException = e;
                    try {
                        if (stream != null) {
                            ((OutputStream)stream).close();
                        }
                        break block17;
                    }
                    catch (IOException e2) {
                        if (caughtException != null) {
                            caughtException = e2;
                        }
                        break block17;
                    }
                }
            }
            catch (Throwable throwable) {
                block18: {
                    try {
                        if (stream != null) {
                            ((OutputStream)stream).close();
                        }
                    }
                    catch (IOException e) {
                        if (caughtException == null) break block18;
                        caughtException = e;
                    }
                }
                throw throwable;
            }
            try {
                if (stream != null) {
                    ((OutputStream)stream).close();
                }
            }
            catch (IOException e) {
                if (caughtException == null) break block17;
                caughtException = e;
            }
        }
        if (caughtException != null) {
            throw caughtException;
        }
    }

    public static void writeConfiguration(BundleInfo[] simpleInfos, OutputStream stream) throws IOException {
        BundleInfo simpleInfo;
        Arrays.sort(simpleInfos, (b1, b2) -> {
            int bsnComparison = b1.getSymbolicName().compareTo(b2.getSymbolicName());
            if (bsnComparison != 0) {
                return bsnComparison;
            }
            return new Version(b2.getVersion()).compareTo(new Version(b1.getVersion()));
        });
        BufferedWriter writer = null;
        boolean oldStyle = false;
        boolean utf8 = true;
        BundleInfo[] bundleInfoArray = simpleInfos;
        int n = simpleInfos.length;
        int n2 = 0;
        while (n2 < n) {
            simpleInfo = bundleInfoArray[n2];
            if ("org.eclipse.equinox.simpleconfigurator".equals(simpleInfo.getSymbolicName())) {
                Version version = new Version(simpleInfo.getVersion());
                if (version.compareTo(OLD_STYLE_SIMPLE_CONFIGURATOR_VERSION) < 0) {
                    oldStyle = true;
                }
                if (version.compareTo(DEFAULT_ENCODING_CONFIGURATOR_VERSION) >= 0) break;
                utf8 = false;
                break;
            }
            ++n2;
        }
        if (utf8) {
            writer = new BufferedWriter(new OutputStreamWriter(stream, "UTF-8"));
            writer.write("#encoding=UTF-8");
            writer.newLine();
        } else {
            writer = new BufferedWriter(new OutputStreamWriter(stream));
        }
        writer.write(SimpleConfiguratorManipulatorUtils.createVersionLine());
        writer.newLine();
        bundleInfoArray = simpleInfos;
        n = simpleInfos.length;
        n2 = 0;
        while (n2 < n) {
            simpleInfo = bundleInfoArray[n2];
            writer.write(SimpleConfiguratorManipulatorUtils.createBundleInfoLine(simpleInfo, oldStyle));
            writer.newLine();
            ++n2;
        }
        writer.flush();
    }

    public static String createVersionLine() {
        return "#version=1";
    }

    public static String createBundleInfoLine(BundleInfo bundleInfo, boolean oldStyle) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(bundleInfo.getSymbolicName());
        buffer.append(',');
        buffer.append(bundleInfo.getVersion());
        buffer.append(',');
        buffer.append(SimpleConfiguratorManipulatorUtils.createBundleLocation(bundleInfo.getLocation(), oldStyle));
        buffer.append(',');
        buffer.append(bundleInfo.getStartLevel());
        buffer.append(',');
        buffer.append(bundleInfo.isMarkedAsStarted());
        return buffer.toString();
    }

    public static String createBundleLocation(URI location, boolean oldStyle) {
        if (oldStyle) {
            String scheme = location.getScheme();
            if (scheme == null) {
                scheme = "file";
            }
            return scheme + ":" + location.getSchemeSpecificPart();
        }
        Object result = location.toString();
        int commaIndex = ((String)result).indexOf(44);
        while (commaIndex != -1) {
            result = ((String)result).substring(0, commaIndex) + "%2C" + ((String)result).substring(commaIndex + 1);
            commaIndex = ((String)result).indexOf(44);
        }
        return result;
    }
}

