/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.expression;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.equinox.p2.metadata.Version;
import org.osgi.framework.FrameworkUtil;

public abstract class CoercingComparator<T> {
    private static CoercingComparator<?>[] coercers = new CoercingComparator[]{new ClassCoercer(), new BooleanCoercer(), new LongCoercer(), new IntegerCoercer(), new VersionCoercer(), new StringCoercer()};
    private static final Class<?>[] constructorType = new Class[]{String.class};

    /*
     * WARNING - void declaration
     */
    public static <TA, TB> int coerceAndCompare(TA o1, TB o2) throws IllegalArgumentException {
        TB TB;
        if (o1 == null || o2 == null) {
            throw new IllegalArgumentException("Cannot compare null to anything");
        }
        TA TA = o1;
        if (TA instanceof Comparable) {
            Comparable comparable = (Comparable)TA;
            Comparable cfr_ignored_0 = (Comparable)TA;
            if (o1.getClass().isAssignableFrom(o2.getClass())) {
                void c1;
                return c1.compareTo(o2);
            }
        }
        if ((TB = o2) instanceof Comparable) {
            Comparable comparable = (Comparable)TB;
            Comparable cfr_ignored_1 = (Comparable)TB;
            if (o2.getClass().isAssignableFrom(o1.getClass())) {
                void c2;
                return -c2.compareTo(o1);
            }
        }
        CoercingComparator<TA> ca = CoercingComparator.getComparator(o1, o2);
        CoercingComparator<TB> cb = CoercingComparator.getComparator(o2, o1);
        return ca.getCoercePrio() <= cb.getCoercePrio() ? ca.compare(o1, ca.coerce(o2)) : cb.compare(cb.coerce(o1), o2);
    }

    public static <TA, TB> boolean coerceAndEquals(TA o1, TB o2) throws IllegalArgumentException {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.getClass() != o2.getClass()) {
            if (o1.getClass().isAssignableFrom(o2.getClass())) {
                return o1.equals(o2);
            }
            if (o2.getClass().isAssignableFrom(o1.getClass())) {
                return o2.equals(o1);
            }
            try {
                CoercingComparator<TA> ca = CoercingComparator.getComparator(o1, o2);
                CoercingComparator<TB> cb = CoercingComparator.getComparator(o2, o1);
                return ca.getCoercePrio() <= cb.getCoercePrio() ? o1.equals(ca.coerce(o2)) : o2.equals(cb.coerce(o1));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return o1.equals(o2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> CoercingComparator<V> getComparator(V value, Object v2) {
        Class<?> vClass = value.getClass();
        CoercingComparator<?>[] carr = coercers;
        int idx = carr.length;
        while (--idx >= 0) {
            CoercingComparator<?> c = carr[idx];
            if (!c.canCoerceTo(vClass)) continue;
            return c;
        }
        if (value instanceof Comparable && v2 instanceof String) {
            Class<?> cClass = vClass;
            try {
                Constructor<?> constructor = cClass.getConstructor(constructorType);
                if (!constructor.isAccessible()) {
                    AccessController.doPrivileged(new SetAccessibleAction(constructor));
                }
                Class<CoercingComparator> clazz = CoercingComparator.class;
                synchronized (CoercingComparator.class) {
                    FromStringCoercer cv;
                    int top = coercers.length;
                    CoercingComparator[] nc = new CoercingComparator[top + 1];
                    System.arraycopy(coercers, 0, nc, 1, top);
                    nc[0] = cv = new FromStringCoercer(cClass, constructor);
                    coercers = nc;
                    // ** MonitorExit[var7_7] (shouldn't be in output)
                    return cv;
                }
            }
            catch (Exception exception) {}
        }
        throw new IllegalArgumentException("No comparator for " + vClass.getName());
    }

    protected IllegalArgumentException uncoercable(Object v) {
        StringBuilder sb = new StringBuilder("Cannot coerce ");
        if (v instanceof String) {
            sb.append('\'');
            sb.append(v);
            sb.append('\'');
        } else if (v instanceof Number) {
            sb.append("number ");
            sb.append(v);
        } else {
            sb.append("an object of instance ");
            sb.append(v.getClass().getName());
        }
        sb.append(" into a ");
        sb.append(this.getCoerceClass().getName());
        return new IllegalArgumentException(sb.toString());
    }

    boolean canCoerceTo(Class<?> cls) {
        return cls == this.getCoerceClass();
    }

    abstract T coerce(Object var1);

    abstract int compare(T var1, T var2);

    abstract Class<T> getCoerceClass();

    abstract int getCoercePrio();

    static class BooleanCoercer
    extends CoercingComparator<Boolean> {
        BooleanCoercer() {
        }

        @Override
        public int compare(Boolean o1, Boolean o2) {
            return o1.booleanValue() == o2.booleanValue() ? 0 : (o1 != false ? 1 : -1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        Boolean coerce(Object v) {
            Object object = v;
            if (object instanceof Boolean) {
                void b;
                Boolean bl = (Boolean)object;
                Boolean cfr_ignored_0 = (Boolean)object;
                return b;
            }
            Object object2 = v;
            if (object2 instanceof String) {
                void s;
                String string = (String)object2;
                String cfr_ignored_1 = (String)object2;
                String sv = s.trim();
                if (sv.equalsIgnoreCase("true")) {
                    return Boolean.TRUE;
                }
                if (sv.equalsIgnoreCase("false")) {
                    return Boolean.FALSE;
                }
            }
            throw this.uncoercable(v);
        }

        @Override
        Class<Boolean> getCoerceClass() {
            return Boolean.class;
        }

        @Override
        int getCoercePrio() {
            return 7;
        }
    }

    static class ClassCoercer
    extends CoercingComparator<Class<?>> {
        ClassCoercer() {
        }

        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            return o1.getName().compareTo(o2.getName());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        Class<?> coerce(Object v) {
            if (v instanceof Class) {
                return (Class)v;
            }
            Object object = v;
            if (object instanceof String) {
                String string = (String)object;
                String cfr_ignored_0 = (String)object;
                try {
                    void s;
                    return FrameworkUtil.getBundle(CoercingComparator.class).loadClass(s.trim());
                }
                catch (Exception exception) {}
            }
            throw this.uncoercable(v);
        }

        @Override
        Class<Class<?>> getCoerceClass() {
            Class<Class> cls = Class.class;
            return cls;
        }

        @Override
        int getCoercePrio() {
            return 11;
        }
    }

    static class FromStringCoercer<T extends Comparable<Object>>
    extends CoercingComparator<T> {
        private final Class<T> coerceClass;
        private final Constructor<T> constructor;

        public FromStringCoercer(Class<T> coerceClass, Constructor<T> constructor) {
            this.coerceClass = coerceClass;
            this.constructor = constructor;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        T coerce(Object v) {
            Object object = v;
            if (object instanceof String) {
                String string = (String)object;
                String cfr_ignored_0 = (String)object;
                try {
                    void s;
                    return (T)((Comparable)this.constructor.newInstance(s.trim()));
                }
                catch (Exception exception) {}
            }
            throw this.uncoercable(v);
        }

        @Override
        int compare(T o1, T o2) {
            return o1.compareTo(o2);
        }

        @Override
        Class<T> getCoerceClass() {
            return this.coerceClass;
        }

        @Override
        int getCoercePrio() {
            return 0;
        }
    }

    static class IntegerCoercer
    extends CoercingComparator<Integer> {
        IntegerCoercer() {
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            return o1.compareTo(o2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        Integer coerce(Object v) {
            Object object = v;
            if (object instanceof Integer) {
                void i;
                Integer n = (Integer)object;
                Integer cfr_ignored_0 = (Integer)object;
                return i;
            }
            Object object2 = v;
            if (object2 instanceof Number) {
                void n;
                Number number = (Number)object2;
                Number cfr_ignored_1 = (Number)object2;
                return n.intValue();
            }
            Object object3 = v;
            if (object3 instanceof String) {
                String string = (String)object3;
                String cfr_ignored_2 = (String)object3;
                try {
                    void s;
                    return Integer.valueOf(s.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            }
            throw this.uncoercable(v);
        }

        @Override
        Class<Integer> getCoerceClass() {
            return Integer.class;
        }

        @Override
        int getCoercePrio() {
            return 6;
        }
    }

    static class LongCoercer
    extends CoercingComparator<Long> {
        LongCoercer() {
        }

        @Override
        public int compare(Long o1, Long o2) {
            return o1.compareTo(o2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        Long coerce(Object v) {
            Object object = v;
            if (object instanceof Long) {
                void l;
                Long l2 = (Long)object;
                Long cfr_ignored_0 = (Long)object;
                return l;
            }
            Object object2 = v;
            if (object2 instanceof Number) {
                void n;
                Number number = (Number)object2;
                Number cfr_ignored_1 = (Number)object2;
                return n.longValue();
            }
            Object object3 = v;
            if (object3 instanceof String) {
                String string = (String)object3;
                String cfr_ignored_2 = (String)object3;
                try {
                    void s;
                    return Long.valueOf(s.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            }
            throw this.uncoercable(v);
        }

        @Override
        Class<Long> getCoerceClass() {
            return Long.class;
        }

        @Override
        int getCoercePrio() {
            return 5;
        }
    }

    private static class SetAccessibleAction
    implements PrivilegedAction<Object> {
        private final AccessibleObject accessible;

        SetAccessibleAction(AccessibleObject accessible) {
            this.accessible = accessible;
        }

        @Override
        public Object run() {
            this.accessible.setAccessible(true);
            return null;
        }
    }

    static class StringCoercer
    extends CoercingComparator<String> {
        StringCoercer() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o1.compareTo(o2);
        }

        @Override
        String coerce(Object v) {
            if (v instanceof Class) {
                return ((Class)v).getName();
            }
            return v.toString();
        }

        @Override
        Class<String> getCoerceClass() {
            return String.class;
        }

        @Override
        int getCoercePrio() {
            return 10;
        }
    }

    static class VersionCoercer
    extends CoercingComparator<Version> {
        VersionCoercer() {
        }

        @Override
        public int compare(Version o1, Version o2) {
            return o1.compareTo(o2);
        }

        @Override
        boolean canCoerceTo(Class<?> cls) {
            return Version.class.isAssignableFrom(cls);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        Version coerce(Object v) {
            Object object = v;
            if (object instanceof Version) {
                void version;
                Version version2 = (Version)object;
                Version cfr_ignored_0 = (Version)object;
                return version;
            }
            Object object2 = v;
            if (object2 instanceof String) {
                String string = (String)object2;
                String cfr_ignored_1 = (String)object2;
                try {
                    void s;
                    return Version.create((String)s);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            throw this.uncoercable(v);
        }

        @Override
        Class<Version> getCoerceClass() {
            return Version.class;
        }

        @Override
        int getCoercePrio() {
            return 1;
        }
    }
}

