/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.jreinfo;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.oomph.internal.jreinfo.JREInfoPlugin;
import org.eclipse.oomph.jreinfo.JREManager;
import org.eclipse.oomph.jreinfo.Messages;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.XMLUtil;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class JREInfo {
    private static final boolean SKIP_USER_HOME = PropertiesUtil.isProperty((String)"oomph.jreinfo.skip.user.home");
    private static final String[] EXTRA_SEARCH_PATH = PropertiesUtil.getProperty((String)"oomph.jreinfo.extra.search.path", (String)"").split(File.pathSeparator);
    public String javaHome;
    public int jdk;
    public JREInfo next;

    public static JREInfo getAll() {
        JREInfo jreInfo = null;
        try {
            File javaHomeFolder;
            switch (JREManager.OS_TYPE) {
                case Win: {
                    jreInfo = JREInfo.getAllWin();
                    break;
                }
                case Mac: {
                    jreInfo = JREInfo.getAllMac();
                    break;
                }
                case Linux: {
                    jreInfo = JREInfo.getAllLinux();
                }
            }
            String javaHome = System.getProperty("java.home");
            if (javaHome != null && (javaHomeFolder = new File(javaHome)).isDirectory()) {
                int jdk = 0;
                try {
                    jdk = JREInfo.isJDK(javaHomeFolder);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                JREInfo info = new JREInfo();
                info.javaHome = javaHomeFolder.getAbsolutePath();
                info.jdk = jdk;
                info.next = jreInfo;
                jreInfo = info;
            }
            if (!SKIP_USER_HOME) {
                String userHome = PropertiesUtil.getUserHome();
                jreInfo = JREInfo.searchFolder(jreInfo, userHome);
                jreInfo = JREInfo.searchFolder(jreInfo, String.valueOf(userHome) + "/java");
                jreInfo = JREInfo.searchFolder(jreInfo, String.valueOf(userHome) + "/jvm");
            }
            int i = 0;
            while (i < EXTRA_SEARCH_PATH.length) {
                String search = EXTRA_SEARCH_PATH[i];
                jreInfo = JREInfo.searchFolder(jreInfo, search);
                ++i;
            }
        }
        catch (Exception ex) {
            JREInfoPlugin.INSTANCE.log(ex);
        }
        return jreInfo;
    }

    private static native JREInfo getAllWin();

    private static JREInfo getAllMac() {
        final JREInfo[] jreInfo = new JREInfo[1];
        try {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.command("/usr/libexec/java_home", "-X");
            Process process = builder.start();
            DocumentBuilder documentBuilder = XMLUtil.createDocumentBuilder();
            documentBuilder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
            Element rootElement = XMLUtil.loadRootElement((DocumentBuilder)documentBuilder, (InputStream)process.getInputStream());
            XMLUtil.handleElementsByTagName((Element)rootElement, (String)"key", (XMLUtil.ElementHandler)new XMLUtil.ElementHandler(){

                public void handleElement(Element element) throws Exception {
                    block6: {
                        try {
                            String text = element.getTextContent();
                            if (text == null || !"JVMHomePath".equals(text.trim())) break block6;
                            Node siblingNode = element.getNextSibling();
                            while (siblingNode != null) {
                                if (siblingNode instanceof Element) {
                                    String javaHome;
                                    Element sibling = (Element)siblingNode;
                                    if ("string".equals(sibling.getNodeName()) && (javaHome = sibling.getTextContent()) != null) {
                                        JREInfo info = new JREInfo();
                                        info.javaHome = javaHome;
                                        info.jdk = JREInfo.isJDK(new File(javaHome));
                                        info.next = jreInfo[0];
                                        jreInfo[0] = info;
                                    }
                                    break;
                                }
                                siblingNode = siblingNode.getNextSibling();
                            }
                        }
                        catch (FileNotFoundException text) {
                        }
                        catch (Exception ex) {
                            JREInfoPlugin.INSTANCE.log(ex);
                        }
                    }
                }
            });
        }
        catch (Exception ex) {
            JREInfoPlugin.INSTANCE.log(ex);
        }
        return jreInfo[0];
    }

    private static JREInfo getAllLinux() {
        JREInfo jreInfo = null;
        jreInfo = JREInfo.searchFolder(jreInfo, "/usr/java");
        jreInfo = JREInfo.searchFolder(jreInfo, "/usr/lib/jvm");
        jreInfo = JREInfo.searchFolder(jreInfo, "/usr/lib64");
        jreInfo = JREInfo.searchFolder(jreInfo, "/usr/lib64/jvm");
        return jreInfo;
    }

    private static JREInfo searchFolder(JREInfo jreInfo, String folder) {
        File[] children = new File(folder).listFiles();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                try {
                    File javaHome = children[i];
                    int jdk = JREInfo.isJDK(javaHome);
                    JREInfo info = new JREInfo();
                    info.javaHome = javaHome.getAbsolutePath();
                    info.jdk = jdk;
                    info.next = jreInfo;
                    jreInfo = info;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
        }
        return jreInfo;
    }

    static int isJDK(File javaHome) throws FileNotFoundException {
        File binFolder = new File(javaHome, "bin");
        if (!binFolder.isDirectory()) {
            throw new FileNotFoundException(NLS.bind((String)Messages.JREInfo_FolderDoesNotExist_exception, (Object)binFolder));
        }
        if (new File(binFolder, JREManager.JAVA_COMPILER).isFile()) {
            return 1;
        }
        return 0;
    }
}

