/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.inject;

import java.util.HashMap;
import java.util.Map;
import org.apache.felix.scr.impl.helper.ComponentMethod;
import org.apache.felix.scr.impl.helper.ComponentMethods;
import org.apache.felix.scr.impl.helper.ReferenceMethods;
import org.apache.felix.scr.impl.inject.ActivateMethod;
import org.apache.felix.scr.impl.inject.BindMethods;
import org.apache.felix.scr.impl.inject.DeactivateMethod;
import org.apache.felix.scr.impl.inject.DuplexReferenceMethods;
import org.apache.felix.scr.impl.inject.FieldMethods;
import org.apache.felix.scr.impl.inject.ModifiedMethod;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.felix.scr.impl.metadata.DSVersion;
import org.apache.felix.scr.impl.metadata.ReferenceMetadata;

public class ComponentMethodsImpl
implements ComponentMethods {
    private ActivateMethod m_activateMethod;
    private ModifiedMethod m_modifiedMethod;
    private DeactivateMethod m_deactivateMethod;
    private final Map<String, ReferenceMethods> bindMethodMap = new HashMap<String, ReferenceMethods>();

    @Override
    public synchronized void initComponentMethods(ComponentMetadata componentMetadata, Class<?> implementationObjectClass) {
        if (this.m_activateMethod != null) {
            return;
        }
        DSVersion dsVersion = componentMetadata.getDSVersion();
        boolean configurableServiceProperties = componentMetadata.isConfigurableServiceProperties();
        boolean supportsInterfaces = componentMetadata.isConfigureWithInterfaces();
        this.m_activateMethod = new ActivateMethod(componentMetadata.getActivate(), componentMetadata.isActivateDeclared(), implementationObjectClass, dsVersion, configurableServiceProperties, supportsInterfaces);
        this.m_deactivateMethod = new DeactivateMethod(componentMetadata.getDeactivate(), componentMetadata.isDeactivateDeclared(), implementationObjectClass, dsVersion, configurableServiceProperties, supportsInterfaces);
        this.m_modifiedMethod = new ModifiedMethod(componentMetadata.getModified(), implementationObjectClass, dsVersion, configurableServiceProperties, supportsInterfaces);
        for (ReferenceMetadata referenceMetadata : componentMetadata.getDependencies()) {
            String refName = referenceMetadata.getName();
            ReferenceMethods methods = referenceMetadata.getField() != null && referenceMetadata.getBind() != null ? new DuplexReferenceMethods(new FieldMethods(referenceMetadata, implementationObjectClass, dsVersion, configurableServiceProperties), new BindMethods(referenceMetadata, implementationObjectClass, dsVersion, configurableServiceProperties)) : (referenceMetadata.getField() != null ? new FieldMethods(referenceMetadata, implementationObjectClass, dsVersion, configurableServiceProperties) : new BindMethods(referenceMetadata, implementationObjectClass, dsVersion, configurableServiceProperties));
            this.bindMethodMap.put(refName, methods);
        }
    }

    @Override
    public ComponentMethod getActivateMethod() {
        return this.m_activateMethod;
    }

    @Override
    public ComponentMethod getDeactivateMethod() {
        return this.m_deactivateMethod;
    }

    @Override
    public ComponentMethod getModifiedMethod() {
        return this.m_modifiedMethod;
    }

    @Override
    public ReferenceMethods getBindMethods(String refName) {
        return this.bindMethodMap.get(refName);
    }
}

