/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.StateDeltaImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;

public class UserState
extends StateImpl {
    private final Set<String> updated = Collections.synchronizedSet(new HashSet());

    @Override
    public boolean removeBundle(BundleDescription description) {
        if (description.getLocation() != null) {
            this.updated.remove(description.getLocation());
        }
        return super.removeBundle(description);
    }

    @Override
    public boolean updateBundle(BundleDescription newDescription) {
        if (!super.updateBundle(newDescription)) {
            return false;
        }
        this.updated.add(newDescription.getLocation());
        return true;
    }

    public StateDelta compare(State baseState) {
        BundleDescription[] existingBundles;
        BundleDescription[] currentBundles = this.getBundles();
        StateDeltaImpl delta = new StateDeltaImpl(this);
        BundleDescription[] bundleDescriptionArray = currentBundles;
        int n = currentBundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription current = bundleDescriptionArray[n2];
            BundleDescription existing = baseState.getBundleByLocation(current.getLocation());
            if (existing == null) {
                delta.recordBundleAdded((BundleDescriptionImpl)current);
            } else if (this.updated.contains(current.getLocation())) {
                delta.recordBundleUpdated((BundleDescriptionImpl)current);
            }
            ++n2;
        }
        BundleDescription[] bundleDescriptionArray2 = existingBundles = baseState.getBundles();
        int n3 = existingBundles.length;
        n = 0;
        while (n < n3) {
            BundleDescription existing = bundleDescriptionArray2[n];
            BundleDescription local = this.getBundleByLocation(existing.getLocation());
            if (local == null) {
                delta.recordBundleRemoved((BundleDescriptionImpl)existing);
            }
            ++n;
        }
        return delta;
    }
}

